<?php

/**
 * The Slovak language file
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Tibor <tibor@topzone.sk>
 * @copyright 2010-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2010-09-11
 * @codingStandardsIgnoreFile
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "sk";
$PMF_LANG["language"] = "Slovak";
$PMF_LANG['direction'] = "ltr";
$PMF_LANG["nplurals"] = "2";

// Navigation
$PMF_LANG["msgCategory"] = "Kategórie";
$PMF_LANG["msgShowAllCategories"] = "Všetky kategórie";
$PMF_LANG["msgSearch"] = "Hľadať";
$PMF_LANG["msgAddContent"] = "Pridať FAQ";
$PMF_LANG["msgQuestion"] = "Položiť otázku";
$PMF_LANG["msgOpenQuestions"] = "Otvoriť otázky";
$PMF_LANG["msgHelp"] = "Pomoc";
$PMF_LANG["msgContact"] = "Kontakt";
$PMF_LANG["msgHome"] = "FAQ Domov";
$PMF_LANG["msgNews"] = "FAQ novinky";
$PMF_LANG["msgUserOnline"] = " Užívateľov online";
$PMF_LANG["msgBack2Home"] = "Späť na úvodnú stránku";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Kategórie s FAQ";
$PMF_LANG["msgFullCategoriesIn"] = "Kategórie s FAQ v ";
$PMF_LANG["msgSubCategories"] = "Podkategórie";
$PMF_LANG["msgEntries"] = "FAQ";
$PMF_LANG["msgEntriesIn"] = "Otázky v ";
$PMF_LANG["msgViews"] = "zobrazení";
$PMF_LANG["msgPage"] = "Strana ";
$PMF_LANG["msgPages"] = " Strany";
$PMF_LANG["msgPrevious"] = "predchádzajúca";
$PMF_LANG["msgNext"] = "nasledujúca";
$PMF_LANG["msgCategoryUp"] = "o kategóriu vyššie";
$PMF_LANG["msgLastUpdateArticle"] = "Posledná aktualizácia: ";
$PMF_LANG["msgAuthor"] = "Autor: ";
$PMF_LANG["msgPrinterFriendly"] = "verzia pre tlač";
$PMF_LANG["msgPrintArticle"] = "Vytlačiť tento záznam";
$PMF_LANG["msgMakeXMLExport"] = "Exportovať ako XML-súbor";
$PMF_LANG["msgAverageVote"] = "Priemerné hodnotenie";
$PMF_LANG["msgVoteUsability"] = "Ohodnoťte tento FAQ";
$PMF_LANG["msgVoteFrom"] = "out of";
$PMF_LANG["msgVoteBad"] = "completely useless";
$PMF_LANG["msgVoteGood"] = "most valuable";
$PMF_LANG["msgVotings"] = "Hlasovaní ";
$PMF_LANG["msgVoteSubmit"] = "Hlasovať";
$PMF_LANG["msgVoteThanks"] = "Ďakujeme za Váš hlas!";
$PMF_LANG["msgYouCan"] = "Môžete ";
$PMF_LANG["msgWriteComment"] = "komentovať tento FAQ";
$PMF_LANG["msgShowCategory"] = "Content Overview: ";
$PMF_LANG["msgCommentBy"] = "Comment of ";
$PMF_LANG["msgCommentHeader"] = "Comment this FAQ";
$PMF_LANG["msgYourComment"] = "Váš komentár";
$PMF_LANG["msgCommentThanks"] = "Ďakujeme veľmi pekne za váš komentár!";
$PMF_LANG["msgSend2Friend"] = "Poslať FAQ známemu";
$PMF_LANG["msgS2FButton"] = "odoslať e-mail";

// Search
$PMF_LANG["msgSearchWord"] = "Kľúčové slovo";
$PMF_LANG["msgSearchFind"] = "Výsledky vyhľadávania pre ";
$PMF_LANG["msgSearchAmount"] = " výsledok vyhľadávania";
$PMF_LANG["msgSearchAmounts"] = " výsledky vyhľadávania";
$PMF_LANG["msgSearchCategory"] = "Kategória: ";
$PMF_LANG["msgSearchContent"] = "Odpoveď: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Návrh novej FAQ";
$PMF_LANG['msgNewContentAddon'] = "Váš návrh sa nezobrazí okamžite, ale pred zverejnením ho skontrolujeme. Povinné polia sú polia označené *.";
$PMF_LANG["msgNewContentName"] = "Vaše meno";
$PMF_LANG["msgNewContentMail"] = "Váš e-mail";
$PMF_LANG["msgNewContentCategory"] = "Kategória";
$PMF_LANG["msgNewContentTheme"] = "Otázka";
$PMF_LANG["msgNewContentArticle"] = "Odpoveď";
$PMF_LANG["msgNewContentKeywords"] = "Kľúčové slovo";
$PMF_LANG["msgNewContentLink"] = "Odkaz na tento záznam";
$PMF_LANG["msgNewContentSubmit"] = "potvrdiť";
$PMF_LANG["msgInfo"] = "Viac informácií: ";
$PMF_LANG["msgNewContentThanks"] = "Ďakujeme za Váš návrh!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Momentálne nie sú žiadne nezodpovedané otázky.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Spýtajte sa na otázku nižšie";
$PMF_LANG["msgAskCategory"] = "Kategória";
$PMF_LANG["msgAskYourQuestion"] = "Otázka";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Ďakujeme za Vašu otázku!</h2>";
$PMF_LANG["msgDate_User"] = "Dátum / Užívateľ";
$PMF_LANG["msgQuestion2"] = "Otázka";
$PMF_LANG["msg2answer"] = "odpoveď";
$PMF_LANG["msgQuestionText"] = "Tu môžete vidieť otázky od ostatných užívateľov. Keď otázku zodpoviete, odpoveď bude vložená do FAQ.";

// Help
$PMF_LANG["msgHelpText"] = "Štruktúra FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) je jednoduchá. Ďalej môžete hľadať <strong><a href=\"?action=show\">categories</a></strong> alebo nechať <strong><a href=\"?action=search\">vyhľadávať FAQ</a></strong> kľúčové slová.";

// Contact
$PMF_LANG["msgContactEMail"] = "E-mail webmasterovi";
$PMF_LANG["msgMessage"] = "Vaša správa";

// Startseite
$PMF_LANG["msgNews"] = " Novinky";
$PMF_LANG["msgTopTen"] = "Najžiadanejšie FAQ";
$PMF_LANG["msgHomeThereAre"] = "Tu sú ";
$PMF_LANG["msgHomeArticlesOnline"] = " FAQ online";
$PMF_LANG["msgNoNews"] = "Žiadna novinka je dobrá novinka.";
$PMF_LANG["msgLatestArticles"] = "Posledné FAQ";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Ďakujeme za návrh FAQ.";
$PMF_LANG["msgMailCheck"] = "Nový vstup FAQ! Prosím skontrolujte sekciu admin!";
$PMF_LANG["msgMailContact"] = "Vaša správa bola poslaná administrátorovi.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Žiadne spojenie s databázou.";
$PMF_LANG["err_noHeaders"] = "Kategória sa nenašla.";
$PMF_LANG["msgErrorNoRecords"] = "FAQ nedostupná.";
$PMF_LANG["err_badID"] = "Chybné ID.";
$PMF_LANG["err_noTopTen"] = "Nie je dostupné žiadne FAQ.";
$PMF_LANG["err_nothingFound"] = "Vstup sa nenašiel.";
$PMF_LANG["err_SaveEntries"] = "Povinné polia sú <strong>Vaše meno</strong>, <strong>Váš e-mail</strong>, <strong>category</strong>, <strong>názov</strong>, <strong>Váš záznam</strong> a, na požiadanie, <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Čítajte viac na Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br><br><a href=\"javascript:history.back();\">o jednu stránku späť</a><br><br>";
$PMF_LANG["err_SaveComment"] = "Povinné polia sú <strong>Vaše meno </strong>, <strong>Váš e-mail</strong>, <strong>Vaše komentáre</strong> a, na požiadanie, <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Čítajte viac na Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br><br><a href=\"javascript:history.back();\">o jednu stránku späť</a><br><br>";
$PMF_LANG["err_VoteTooMuch"] = "Dvojité hlasovania nebudú započítané.";
$PMF_LANG["err_noVote"] = "<strong>Neohodnotili ste otázku!</strong> <a href=\"javascript:history.back();\">Prosím kliknite sem</a>, pre hlasovanie.";
$PMF_LANG["err_noMailAdress"] = "Váš e-mail je nesprávny.<br><a href=\"javascript:history.back();\">späť</a>";
$PMF_LANG["err_sendMail"] = "Povinné polia sú <strong>Vaše meno</strong>, <strong>Váš e-mail</strong>, <strong>your question</strong> a, na požiadanie, <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Čítajte viac na Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Hľadanie záznamu:</strong><br>So vstupnými údajmi <strong style=\"color: Red;\">slovo1 slovo2</strong> môžete vyhľadávať aj vzostupne pre dve alebo viac hľadaných výrazov.<strong>Poznámka:</strong> Hľadané výrazy musia mať aspoň 4 písmená a preto bude Vaša požiadavka zrušená.";

// Menï¿½
$PMF_LANG["ad"] = "SEKCIA PRE ADMINISTRÁTORA";
$PMF_LANG["ad_menu_user_administration"] = "Užívatelia";
$PMF_LANG["ad_menu_entry_aprove"] = "Schválené FAQ";
$PMF_LANG["ad_menu_entry_edit"] = "Upraviť FAQ";
$PMF_LANG["ad_menu_categ_add"] = "Pridať kategóriu";
$PMF_LANG["msgHeaderCategoryOverview"] = "Upraviť kategóriu";
$PMF_LANG["ad_menu_news_add"] = "Pridať novinky";
$PMF_LANG["ad_menu_news_edit"] = "Upraviť novinky";
$PMF_LANG["ad_menu_open"] = "Otvoriť otázky";
$PMF_LANG["ad_menu_stat"] = "Štatistiky";
$PMF_LANG["ad_menu_cookie"] = "Nastaviť cookies";
$PMF_LANG["ad_menu_session"] = "Zobraziť Sessions";
$PMF_LANG["ad_menu_adminlog"] = "Zobraziť Adminlog";
$PMF_LANG["ad_menu_passwd"] = "Zmeniť heslo";
$PMF_LANG["ad_menu_logout"] = "Odhlásiť";
$PMF_LANG["ad_menu_startpage"] = "Úvodná stránka";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Prosím identifikujte sa.";
$PMF_LANG["ad_msg_passmatch"] = "Obe heslá sa musia <strong>zhodovať</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Profil";
$PMF_LANG["ad_msg_savedsuc_2"] = "bol úspešne uložený.";
$PMF_LANG["ad_msg_mysqlerr"] = "Vzhľadom k <strong>chybe databázy</strong>, profil nemôže byť uložený.";
$PMF_LANG["ad_msg_noauth"] = "Nie ste poverený.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Strana";
$PMF_LANG["ad_gen_of"] = "z";
$PMF_LANG["ad_gen_lastpage"] = "Predchádzajúca strana";
$PMF_LANG["ad_gen_nextpage"] = "Ďalšia Strana";
$PMF_LANG["ad_gen_save"] = "Ulož";
$PMF_LANG["ad_gen_reset"] = "Reset";
$PMF_LANG["ad_gen_yes"] = "Áno";
$PMF_LANG["ad_gen_no"] = "Nie";
$PMF_LANG["ad_gen_top"] = "Na vrch stránky";
$PMF_LANG["ad_gen_ncf"] = "Kategória nenájdená!";
$PMF_LANG["ad_gen_delete"] = "Vymaž";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Správa užívateľov";
$PMF_LANG["ad_user_username"] = "Registrovaní užívatelia";
$PMF_LANG["ad_user_rights"] = "Práva užívateľov";
$PMF_LANG["ad_user_edit"] = "uprav";
$PMF_LANG["ad_user_delete"] = "vymaž";
$PMF_LANG["ad_user_add"] = "Pridať užívateľa";
$PMF_LANG["ad_user_profou"] = "Profil užívateľa";
$PMF_LANG["ad_user_name"] = "Meno";
$PMF_LANG["ad_user_password"] = "Heslo";
$PMF_LANG["ad_user_confirm"] = "Potvrď";
$PMF_LANG["ad_user_rights"] = "Práva";
$PMF_LANG["ad_user_del_1"] = "Užívateľ";
$PMF_LANG["ad_user_del_2"] = "môže byť vymazaný?";
$PMF_LANG["ad_user_del_3"] = "Ste si istý?";
$PMF_LANG["ad_user_deleted"] = "Užívateľ bol úspešne vymazaný.";
$PMF_LANG["ad_user_checkall"] = "Vyberte všetkých";

// Beitragsverwaltung
$PMF_LANG["msgHeaderFAQOverview"] = "Správa nahrávok";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Téma";
$PMF_LANG["ad_entry_action"] = "Akcia";
$PMF_LANG["ad_entry_edit_1"] = "Uprav nahrávku";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Otázka";
$PMF_LANG["ad_entry_content"] = "Odpoveď";
$PMF_LANG["ad_entry_keywords"] = "Kľúčové slová";
$PMF_LANG["ad_entry_author"] = "Autor";
$PMF_LANG["ad_entry_category"] = "Kategória";
$PMF_LANG["ad_entry_active"] = "Aktívny?";
$PMF_LANG["ad_entry_date"] = "Dátum";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "Zmenený?";
$PMF_LANG["ad_entry_changelog"] = "Changelog";
$PMF_LANG["ad_entry_commentby"] = "Komentoval";
$PMF_LANG["ad_entry_comment"] = "Komentáre";
$PMF_LANG["ad_entry_save"] = "Ulož";
$PMF_LANG["msgDelete"] = "vymaž";
$PMF_LANG["ad_entry_delcom_1"] = "Ste si istý, že komentár užívateľa";
$PMF_LANG["ad_entry_delcom_2"] = "môže byť vymazaný?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Komentár bol <strong>úspešne</strong> vymazaný.";
$PMF_LANG["ad_entry_back"] = "Späť na článok";
$PMF_LANG["ad_entry_commentdelfail"] = "Komentár <strong>nebol</strong> vymazaný.";
$PMF_LANG["ad_entry_savedsuc"] = "Zmeny boli uložené <strong>úspešne</strong>.";
$PMF_LANG["ad_entry_savedfail"] = "Žiaľ, <strong>vyskytla sa chyba</strong> v databáze.";
$PMF_LANG["ad_entry_del_1"] = "Ste si istý, že téma";
$PMF_LANG["ad_entry_del_2"] = "z";
$PMF_LANG["ad_entry_del_3"] = "môže byť vymazaná?";
$PMF_LANG["ad_entry_delsuc"] = "Otázka <strong>úspešne</strong> vymazaná.";
$PMF_LANG["ad_entry_delfail"] = "Otázka <strong>nebola vymazaná</strong>!";
$PMF_LANG["ad_entry_back"] = "Späť";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Názov článku";
$PMF_LANG["ad_news_text"] = "Text záznamu";
$PMF_LANG["ad_news_link_url"] = "Odkaz";
$PMF_LANG["ad_news_link_title"] = "Názov odkazu";
$PMF_LANG["ad_news_link_target"] = "Cieľ odkazu";
$PMF_LANG["ad_news_link_window"] = "Odkaz sa otvorí v novom okne";
$PMF_LANG["ad_news_link_faq"] = "Odkaz bez FAQ";
$PMF_LANG["ad_news_add"] = "Pridať novinky";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Názov";
$PMF_LANG["ad_news_date"] = "Dátum";
$PMF_LANG["ad_news_action"] = "Akcia";
$PMF_LANG["ad_news_update"] = "aktualizovať";
$PMF_LANG["ad_news_delete"] = "vymazať";
$PMF_LANG["ad_news_nodata"] = "V databáze neboli nájdené žiadne údaje";
$PMF_LANG["ad_news_updatesuc"] = "Novinky boli aktualizované.";
$PMF_LANG["ad_news_del"] = "Ste si istý, že si prajete vymazať túto novú položku?";
$PMF_LANG["ad_news_yesdelete"] = "áno, vymaž!";
$PMF_LANG["ad_news_nodelete"] = "nie!";
$PMF_LANG["ad_news_delsuc"] = "Novinka vymazaná.";
$PMF_LANG["ad_news_updatenews"] = "Novinka aktualizovaná.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Pridať novú kategóriu";
$PMF_LANG["ad_categ_catnum"] = "Číslo kategórie";
$PMF_LANG["ad_categ_subcatnum"] = "Číslo podkategórie";
$PMF_LANG["ad_categ_nya"] = "<em>nie je prístupné!</em>";
$PMF_LANG["ad_categ_titel"] = "Názov kategórie";
$PMF_LANG["ad_categ_add"] = "Pridať kategóriu";
$PMF_LANG["ad_categ_existing"] = "Existujúce kategórie";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Kategória";
$PMF_LANG["ad_categ_subcateg"] = "Podkategória";
$PMF_LANG["ad_categ_titel"] = "Názov kategórie";
$PMF_LANG["ad_categ_action"] = "Akcia";
$PMF_LANG["ad_categ_update"] = "aktualizovať";
$PMF_LANG["ad_categ_delete"] = "vymazať";
$PMF_LANG["ad_categ_updatecateg"] = "Aktualizovať kategóriu";
$PMF_LANG["ad_categ_nodata"] = "V databáze neboli nájdené žiadne údaje";
$PMF_LANG["msgCategoryRemark"] = "Majte prosím na pamäti, že keď vymažete kategóriu, dané položky už viac nebudú viditeľné. Článku musíte prideliť novú kategóriu alebo vymažte článok.";
$PMF_LANG["ad_categ_edit_1"] = "Uprav";
$PMF_LANG["ad_categ_edit_2"] = "Kategória";
$PMF_LANG["ad_categ_add"] = "pridať kategóriu";
$PMF_LANG["ad_categ_added"] = "Kategória bola pridaná.";
$PMF_LANG["ad_categ_updated"] = "Kategória bola aktualizovaná.";
$PMF_LANG["ad_categ_del_yes"] = "áno, vymaž!";
$PMF_LANG["ad_categ_del_no"] = "nie!";
$PMF_LANG["ad_categ_deletesure"] = "Ste si istý, že chcete túto kategóriu vymazať?";
$PMF_LANG["ad_categ_deleted"] = "Kategória vymazaná.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Cookie boli <strong>úspešne</strong> nastavené.";
$PMF_LANG["ad_cookie_already"] = "Cookie boli už nastavené. Teraz máte nasledovné možnosti";
$PMF_LANG["ad_cookie_again"] = "Nastaviť cookie znovu";
$PMF_LANG["ad_cookie_delete"] = "Vymazať cookie";
$PMF_LANG["ad_cookie_no"] = "Cookie ešte neboli uložené. S cookie môžete uložiť Váš prihlasovací skript, pri ďalšej návšteve si nemusíte pamätať Vaše prihlasovacie údaje. Teraz máte nasledovné možnosti";
$PMF_LANG["ad_cookie_set"] = "Nastaviť cookie";
$PMF_LANG["ad_cookie_deleted"] = "Cookie úspešne vymazané.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "AdminLog";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Zmeniť Vaše heslo";
$PMF_LANG["ad_passwd_old"] = "Staré heslo";
$PMF_LANG["ad_passwd_new"] = "Nové heslo";
$PMF_LANG["ad_passwd_con"] = "Potvrdiť";
$PMF_LANG["ad_passwd_change"] = "Zmeniť heslo";
$PMF_LANG["ad_passwd_suc"] = "Heslo úspešne zmenené.";
$PMF_LANG["ad_passwd_remark"] = "<strong>UPOZORNENIE:</strong><br>Cookie boli znovu nastavené!";
$PMF_LANG["ad_passwd_fail"] = "Staré heslo <strong>musí</strong> byť vložené správne a obe nové heslá sa musia <strong>zhodovať</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Pridať užívateľa";
$PMF_LANG["ad_adus_name"] = "Meno";
$PMF_LANG["ad_adus_password"] = "Heslo";
$PMF_LANG["ad_adus_add"] = "Pridať užívateľa";
$PMF_LANG["ad_adus_suc"] = "Užívateľ <strong>úspešne</strong> pridaný.";
$PMF_LANG["ad_adus_edit"] = "Upraviť profil";
$PMF_LANG["ad_adus_dberr"] = "<strong>chyba v databáze!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Užívateľské meno <strong>už</strong> existuje.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "ID sekcie";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Čas";
$PMF_LANG["ad_sess_pageviews"] = "Zobrazenia stránok";
$PMF_LANG["ad_sess_search"] = "Hľadať";
$PMF_LANG["ad_sess_sfs"] = "Hľadať sekcie";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "min. akcie";
$PMF_LANG["ad_sess_s_date"] = "Dátum";
$PMF_LANG["ad_sess_s_after"] = "po";
$PMF_LANG["ad_sess_s_before"] = "pred";
$PMF_LANG["ad_sess_s_search"] = "Hľadať";
$PMF_LANG["ad_sess_session"] = "Sekcie";
$PMF_LANG["ad_sess_r"] = "Hľadať výsledky pre";
$PMF_LANG["ad_sess_referer"] = "Referer";
$PMF_LANG["ad_sess_browser"] = "Vyhľadávač";
$PMF_LANG["ad_sess_ai_rubrik"] = "Kategória";
$PMF_LANG["ad_sess_ai_artikel"] = "Záznam";
$PMF_LANG["ad_sess_ai_sb"] = "Hľadaný reťazec";
$PMF_LANG["ad_sess_ai_sid"] = "ID sekcie";
$PMF_LANG["ad_sess_back"] = "Späť";

// Statistik
$PMF_LANG["ad_rs"] = "Hodnotenie štatistiky";
$PMF_LANG["ad_rs_rating_1"] = "Poradie";
$PMF_LANG["ad_rs_rating_2"] = "users shows";
$PMF_LANG["ad_rs_red"] = "Červená";
$PMF_LANG["ad_rs_green"] = "Zelená";
$PMF_LANG["ad_rs_altt"] = "s priemerom nižším ako 20%";
$PMF_LANG["ad_rs_ahtf"] = "s priemerom vyšším ako 80%";
$PMF_LANG["ad_rs_no"] = "Žiadne poradie";

// Auth
$PMF_LANG["ad_auth_insert"] = "Prosím vložte svoje meno a heslo.";
$PMF_LANG["ad_auth_user"] = "Užívateľské meno";
$PMF_LANG["ad_auth_passwd"] = "Heslo";
$PMF_LANG["ad_auth_ok"] = "OK";
$PMF_LANG["ad_auth_reset"] = "Reset";
$PMF_LANG["ad_auth_fail"] = "Nesprávne meno alebo heslo.";
$PMF_LANG["ad_auth_sess"] = "ID sekcie správne.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Uprav nastavenia";
$PMF_LANG["ad_config_save"] = "Ulož nastavenia";
$PMF_LANG["ad_config_reset"] = "Reset";
$PMF_LANG["ad_config_saved"] = "Nastavenia boli úspešne uložené.";
$PMF_LANG["ad_menu_editconfig"] = "Uprav nastavenia";
$PMF_LANG["ad_att_none"] = "Nie sú dostupné žiadne prílohy";
$PMF_LANG["ad_att_att"] = "Prílohy";
$PMF_LANG["ad_att_add"] = "Priložiť súbor";
$PMF_LANG["ad_entryins_suc"] = "Záznam úspešne uložený.";
$PMF_LANG["ad_entryins_fail"] = "Vyskytla sa chyba.";
$PMF_LANG["ad_att_del"] = "Vymazať";
$PMF_LANG["ad_att_nope"] = "Prílohy môžu byť pridané len počas úprav.";
$PMF_LANG["ad_att_delsuc"] = "Príloha bola úspešne vymazaná.";
$PMF_LANG["ad_att_delfail"] = "Počas mazania súboru sa vyskytla chyba.";
$PMF_LANG["ad_entry_add"] = "Pridať FAQ";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Zálohou je kompletný obraz databázy. Formát zálohy je SQL súbor, a môže byť importovaný použitím nástrojov ako phpMyAdmin alebo príkazového riadku sql klienta. Záloha môže byť ukladaná najmenej jedenkrát za mesiac.";
$PMF_LANG["ad_csv_link"] = "Stiahnuť zálohu";
$PMF_LANG["ad_csv_head"] = "Vytvoriť zálohu";
$PMF_LANG["ad_att_addto"] = "Pridať prílohu k otázke";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Súbor";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "Súbor bol úspešne priložený.";
$PMF_LANG["ad_att_fail"] = "Počas ukladania súboru sa vyskytla chyba.";
$PMF_LANG["ad_att_close"] = "Zatvoriť toto okno";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "S týmto formulárom môžete obnoviť obsah databázy, s použitím zálohy phpmyfaq. Prosím majte na pamäti, že existujúce údaje budú prepísané.";
$PMF_LANG["ad_csv_file"] = "Súbor";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "Záloha LOGs";
$PMF_LANG["ad_csv_linkdat"] = "Záloha";
$PMF_LANG["ad_csv_head2"] = "Obnoviť";
$PMF_LANG["ad_csv_no"] = "Toto nevypadá ako záloha phpmyfaq.";
$PMF_LANG["ad_csv_prepare"] = "Príprava otázok databázy...";
$PMF_LANG["ad_csv_process"] = "Dotazovanie...";
$PMF_LANG["ad_csv_of"] = "z";
$PMF_LANG["ad_csv_suc"] = "boli úspešné.";
$PMF_LANG["ad_csv_backup"] = "Záloha";
$PMF_LANG["ad_csv_rest"] = "Obnoviť zálohu";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Záloha";
$PMF_LANG["ad_logout"] = "Sekcia úspešne ukončená.";
$PMF_LANG["ad_news_add"] = "Pridať novinky";
$PMF_LANG["ad_news_edit"] = "Upraviť novinky";
$PMF_LANG["ad_cookie"] = "Cookies";
$PMF_LANG["ad_sess_head"] = "Zobraziť sekcie";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["msgHeaderCategoryOverview"] = "Kategórie";
$PMF_LANG["ad_menu_stat"] = "Hodnotiace štatistiky";
$PMF_LANG["msgAddCategory"] = "pridať hlavnú kategóriu";
$PMF_LANG["ad_kateg_rename"] = "Premenovať";
$PMF_LANG["ad_adminlog_date"] = "Dátum";
$PMF_LANG["ad_adminlog_user"] = "Užívateľ";
$PMF_LANG["ad_adminlog_ip"] = "IP adresa";

$PMF_LANG["ad_stat_sess"] = "Sekcie";
$PMF_LANG["ad_stat_days"] = "Dni";
$PMF_LANG["ad_stat_vis"] = "Sekcie (Návštevy)";
$PMF_LANG["ad_stat_vpd"] = "Návštevy za deň";
$PMF_LANG["ad_stat_fien"] = "Prvé prihlásenie";
$PMF_LANG["ad_stat_laen"] = "Posledné prihlásenie";
$PMF_LANG["ad_stat_browse"] = "vyhľadať sekciu";
$PMF_LANG["ad_stat_ok"] = "OK";

$PMF_LANG["ad_sess_time"] = "Čas";
$PMF_LANG["ad_sess_sid"] = "ID sekcie";
$PMF_LANG["ad_sess_ip"] = "IP adresa";

$PMF_LANG["ad_ques_take"] = "Pridať otázku a upravovať";
$PMF_LANG["no_cats"] = "Žiadne kategórie nenájdené.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Chybné meno alebo heslo.";
$PMF_LANG["ad_log_sess"] = "Sekcia vypršala.";
$PMF_LANG["ad_log_edit"] = "\"Edit User\"-Formulár pre nasledovného užívateľa: ";
$PMF_LANG["ad_log_crea"] = "\"New article\" formulár.";
$PMF_LANG["ad_log_crsa"] = "Nová položka vytvorená.";
$PMF_LANG["ad_log_ussa"] = "Aktualizovať údaje pre nasledovného užívateľa: ";
$PMF_LANG["ad_log_usde"] = "Vymazať nasledovného užívateľa: ";
$PMF_LANG["ad_log_beed"] = "Upraviť formulár pre nasledovného užívateľa: ";
$PMF_LANG["ad_log_bede"] = "Vymazať nasledovnú položku: ";

$PMF_LANG["msgVisits"] = "Návštevy";
$PMF_LANG["ad_start_articles"] = "Články";
$PMF_LANG["ad_start_comments"] = "Komentáre";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "vložiť";
$PMF_LANG["ad_categ_cut"] = "vystrihnúť";
$PMF_LANG["msgCopy"] = "kopírovať";
$PMF_LANG["ad_categ_process"] = "Spracovanie kategórií...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Nemáte oprávnenie.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "predchádzajúca stránka";
$PMF_LANG["msgNextPage"] = "ďalšia stránka";
$PMF_LANG["msgPageDoublePoint"] = "Strana: ";
$PMF_LANG["msgMainCategory"] = "Hlavná kategória";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Vaše heslo bolo zmenené.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "Zobraziť ako PDF súbor";
$PMF_LANG["ad_xml_head"] = "XML-záloha";
$PMF_LANG["ad_xml_hint"] = "Uložiť všetky záznamy FAQ do jedného XML súboru.";
$PMF_LANG["ad_xml_gen"] = "vytvoriť XML súbor";
$PMF_LANG["ad_entry_locale"] = "Jazyk";
$PMF_LANG["msgLanguageSubmit"] = "Zvoliť jazyk";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Náhľad";
$PMF_LANG["ad_attach_1"] = "Prosím v nastaveniach najprv vyberte priečinok pre prílohy.";
$PMF_LANG["ad_attach_2"] = "Prosím v nastaveniach najprv zvoľte odkaz pre prílohy.";
$PMF_LANG["ad_attach_3"] = "Súbor príloha.php nemôže byť otvorený bez správnej autentifikácie.";
$PMF_LANG["ad_attach_4"] = "Priložený súbor musí mať menšiu veľkosť ako %s Bytov.";
$PMF_LANG["ad_menu_export"] = "Exportovať Vašu FAQ";
$PMF_LANG["ad_export_file"] = "Chyba: Súbor nemožno zapísať.";
$PMF_LANG["ad_export_pdf"] = "PDF-Exportovať všetky záznamy";

$PMF_LANG['permission::add_user'] = "pridať užívateľa";
$PMF_LANG['permission::edit_user'] = "upraviť užívateľa";
$PMF_LANG['permission::delete_user'] = "vymazať užívateľa";
$PMF_LANG['permission::add_faq'] = "pridať záznam";
$PMF_LANG['permission::edit_faq'] = "upraviť záznam";
$PMF_LANG['permission::delete_faq'] = "vymazať záznam";
$PMF_LANG['permission::viewlog'] = "zobraziť log";
$PMF_LANG['permission::adminlog'] = "zobraziť admin log";
$PMF_LANG['permission::delcomment'] = "vymazať komentár";
$PMF_LANG['permission::addnews'] = "pridať novinky";
$PMF_LANG['permission::editnews'] = "upraviť novinky";
$PMF_LANG['permission::delnews'] = "vymazať novinky";
$PMF_LANG['permission::addcateg'] = "pridať kategóriu";
$PMF_LANG['permission::editcateg'] = "upraviť kategóriu";
$PMF_LANG['permission::delcateg'] = "vymazať kategóriu";
$PMF_LANG['permission::passwd'] = "zmeniť heslo";
$PMF_LANG['permission::editconfig'] = "upraviť nastavenie";
$PMF_LANG['permission::addatt'] = "pridať prílohu";
$PMF_LANG['permission::delatt'] = "vymauať prílohy";
$PMF_LANG['permission::backup'] = "vytvoriť zálohu";
$PMF_LANG['permission::restore'] = "obnoviť zálohu";
$PMF_LANG['permission::delquestion'] = "vymazať otvorené otázky";
$PMF_LANG['permission::changebtrevs'] = "upraviť zmeny";

$PMF_LANG["msgAttachedFiles"] = "priložené súbory";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "akcia";
$PMF_LANG["msgEmail"] = "E-mailová adresa";
$PMF_LANG["ad_entry_allowComments"] = "Povoliť komentáre";
$PMF_LANG["msgWriteNoComment"] = "Nemôžete komentovať túto položku";
$PMF_LANG["msgRealname"] = "skutočné meno";
$PMF_LANG["ad_export_generate_pdf"] = "generovať PDF súbor";
$PMF_LANG["ad_export_full_faq"] = "Vaša FAQ ako PDF súbor: ";
$PMF_LANG["err_bannedIP"] = "Vaša IP adresa bola odmietnutá.";
$PMF_LANG["err_SaveQuestion"] = "Povinné polia sú <strong>Vaše meno</strong>, <strong>Váš e-mail</strong>, <strong>Vaša otázka</strong> a, na požiadanie, <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Viac čítajte na Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>.<br><br><a href=\"javascript:history.back();\">o jednu stránku späť</a><br><br>";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Farba písma: ";
$PMF_LANG["ad_entry_fontsize"] = "Veľkosť písma: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array("select", "Language-File");
$LANG_CONF["main.languageDetection"] = array("checkbox", "Povoliť automatický obsah jednania");
$LANG_CONF['main.titleFAQ'] = array("input", "Názov FAQ");
$LANG_CONF['main.currentVersion'] = array("tlačiť", "Verzia FAQ");
$LANG_CONF["main.metaDescription"] = array("input", "Popis stránky");
$LANG_CONF["main.metaPublisher"] = array("input", "Meno vydavateľa");
$LANG_CONF['main.administrationMail'] = array("input", "E-mailová adresa administrátora");
$LANG_CONF["main.contactInformation"] = array("area", "Kontaktné informácie");
$LANG_CONF["main.send2friendText"] = array("area", "Text pre odkaz poslať známemu");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "maximumálna veľkosť prílohy v Bytoch (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", "Pripojiť prílohu k položkám?");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", "použiť stopovač?");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", "použiť Adminlog?");
$LANG_CONF["security.ipCheck"] = array("checkbox", "Chcete aby bola IP skontrolovaná pri kontrole UINs v admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", "Počet tém na stránku");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", "Počet článkov");
$LANG_CONF['security.bannedIPs'] = array("area", "Zakázať tieto IP");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", "Chcete povoliť LDAP podporu? (Prednastavené: nepovoliť)");
$LANG_CONF["main.referenceURL"] = array("input", "Overiť URL (e.g.: https://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array("input", "Interval medzi AJAX overením (v sekundách)");
$LANG_CONF["records.enableVisibilityQuestions"] = array("checkbox", "Vypnúť viditeľnosť nových otázok?");
$LANG_CONF['security.permLevel'] = array("select", "Úroveň povolenia");

$PMF_LANG["ad_categ_new_main_cat"] = "ako novú hlavnú kategóriu";
$PMF_LANG["ad_categ_paste_error"] = "Presunúť túto kategóriu nie je možné.";
$PMF_LANG["ad_categ_move"] = "presunúť kategóriu";
$PMF_LANG["ad_categ_lang"] = "Jazyk";
$PMF_LANG["ad_categ_desc"] = "Popis";
$PMF_LANG["ad_categ_change"] = "Zmeniť šírku";

$PMF_LANG["lostPassword"] = "Zabudli ste heslo? Kliknite sem.";
$PMF_LANG["lostpwd_err_1"] = "Chyba: Užívateľské meno a e-mail nenájdený.";
$PMF_LANG["lostpwd_err_2"] = "Chyba: Zlé položky!";
$PMF_LANG["lostpwd_text_1"] = "Ďakujeme za žiadosť o informáciu o Vašom účte.";
$PMF_LANG["lostpwd_text_2"] = "Prosím nastavte nové heslo pre Vašu FAQ v sekcii admin.";
$PMF_LANG["lostpwd_mail_okay"] = "E-mail bol odoslaný.";

$PMF_LANG["msgButtonFetchLatestVersion"] = "Obdržať najnovšiu phpMyFAQ verziu webovým servisom";
$PMF_LANG["ad_xmlrpc_latest"] = "Najnovšia verzia dostupná na";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Vyberte jazyk kategórie';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Mapa stránok';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Na tejto položke sa pracuje a nemôže byť zobrazená.';
$PMF_LANG['msgArticleCategories'] = 'Kategórie pre tento záznam';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'Unikátne riešenie ID';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ záznam';
$PMF_LANG['ad_entry_new_revision'] = 'Vytvoriť novú revíziu?';
$PMF_LANG['ad_entry_record_administration'] = 'Administrácia záznamov';
$PMF_LANG['ad_entry_changelog'] = 'Changelog';
$PMF_LANG['ad_entry_revision'] = 'Revízie';
$PMF_LANG['ad_changerev'] = 'Vyberte revíziu';
$PMF_LANG['msgCaptcha'] = "Prosím vložte znaky z obrázku";
$PMF_LANG['msgSelectCategories'] = 'Vyhľadávať vo ...';
$PMF_LANG['msgAllCategories'] = '...  všetkých kategóriách';
$PMF_LANG['ad_you_should_update'] = 'Vaša phpMyFAQ inštalácia je zastaralá. Môžete si stiahnuť novú verziu.';
$PMF_LANG['msgAdvancedSearch'] = 'Rozšírené vyhľadávanie';

// added v1.6.1 - 2006-04-25 by Matteoï¿½andï¿½Thorsten
$PMF_LANG['spamControlCenter'] = 'Spam kontrolné centrum';
$LANG_CONF["spam.enableSafeEmail"] = array("checkbox", "Vytlačiť užívateľov e-mail v bezpečnom móde (prednastavené: povoliť).");
$LANG_CONF["spam.checkBannedWords"] = array("checkbox", "Skontrolovať obsahovú formu proti zakázaným slovám (prednastavené: povoliť).");
$LANG_CONF["spam.enableCaptchaCode"] = array("checkbox", "Použiť captcha kód pre povolenie verejnej formy podania (prednastavené: povoliť).");
$PMF_LANG['ad_session_expiring'] = 'Vaše sedenie vyprší o %d minút: chcete pokračovať v práci?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Manažér sedenia';
$PMF_LANG['ad_stat_choose'] = 'Vyberte mesiac';
$PMF_LANG['ad_stat_delete'] = 'Vymazať vybrané sedenia';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Slovník';
$PMF_LANG['ad_glossary_add'] = 'Pridať položku do slovníka';
$PMF_LANG['ad_glossary_edit'] = 'Upraviť položku v slovníku';
$PMF_LANG['ad_glossary_item'] = 'Položka';
$PMF_LANG['ad_glossary_definition'] = 'Definícia';
$PMF_LANG['ad_glossary_save'] = 'Uložiť položku';
$PMF_LANG['ad_glossary_save_success'] = 'Položka úspešne uložená do slovníka!';
$PMF_LANG['ad_glossary_save_error'] = 'Vyskytla sa chyba. Položka sa do slovníka neuložila.';
$PMF_LANG['ad_glossary_update_success'] = 'Položka sa do slovníka úspešne uložila!';
$PMF_LANG['ad_glossary_update_error'] = 'Vyskytla sa chyba. Položka sa neaktualizovala.';
$PMF_LANG['ad_glossary_delete'] = 'Vymazať položku';
$PMF_LANG['ad_glossary_delete_success'] = 'Položka zo slovníka úspešne vymazaná!';
$PMF_LANG['ad_glossary_delete_error'] = 'Vyskytla sa chyba. Položka zo slovníka nemohla byť vymazaná.';
$PMF_LANG['msgNewQuestionVisible'] = 'Otázka musí byť pred publikovaním preskúmaná.';
$PMF_LANG['msgQuestionsWaiting'] = 'Čakajte na publikovanie administrátorom: ';
$PMF_LANG['ad_entry_visibility'] = 'Publikovať?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] = "Prosím zadajte heslo. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "Heslá sa nezhodujú. ";
$PMF_LANG['ad_user_error_loginInvalid'] = "Užívateľské meno je nesprávne.";
$PMF_LANG['ad_user_error_noEmail'] = "Prosím vložte správnu e-mailovú adresu. ";
$PMF_LANG['ad_user_error_noRealName'] = "Prosím vložte Vaše skutočné meno. ";
$PMF_LANG['ad_user_error_delete'] = "Konto užívateľa nemôže byť vymazané. ";
$PMF_LANG['ad_user_error_noId'] = "Žiadna ID. ";
$PMF_LANG['ad_user_error_protectedAccount'] = "Konto užívateľa je chránené. ";
$PMF_LANG['ad_user_deleteUser'] = "Vymazať užívateľa";
$PMF_LANG['ad_user_status'] = "Status";
$PMF_LANG['ad_user_lastModified'] = "naposledy upravované";
$PMF_LANG['ad_gen_cancel'] = "Cancel";
$PMF_LANG['permission::addglossary'] = "pridať položku slovníka";
$PMF_LANG['permission::editglossary'] = "upraviť položku slovníka";
$PMF_LANG['permission::delglossary'] = "vymazať položku slovníka";
$PMF_LANG["ad_menu_group_administration"] = "Skupiny";
$PMF_LANG['ad_user_loggedin'] = 'Prihlásiť ako ';

$PMF_LANG['ad_group_details'] = "Detaily skupiny";
$PMF_LANG['ad_group_add'] = "Pridať skupinu";
$PMF_LANG['ad_group_add_link'] = "Pridať skupinu";
$PMF_LANG['ad_group_name'] = "Meno";
$PMF_LANG['ad_group_description'] = "Popis";
$PMF_LANG['ad_group_autoJoin'] = "Auto-spájanie";
$PMF_LANG['ad_group_suc'] = "Skupina <strong>successfully</strong> pridaná.";
$PMF_LANG['ad_group_error_noName'] = "Prosím zadajte meno skupiny. ";
$PMF_LANG['ad_group_error_delete'] = "Skupina nemôže byť vymazaná. ";
$PMF_LANG['ad_group_deleted'] = "Skupina bola uspešne vymazaná.";
$PMF_LANG['ad_group_deleteGroup'] = "Vymazať skupinu";
$PMF_LANG['ad_group_deleteQuestion'] = "Ste si istý, že skupina môže byť vamazaná?";
$PMF_LANG['ad_user_uncheckall'] = "Zrušiť výber pre všetky";
$PMF_LANG['ad_group_membership'] = "Členstvo v skupine";
$PMF_LANG['ad_group_members'] = "Členovia";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Obmedziť výstupné dáta FAQ (voliteľné)';
$PMF_LANG['ad_export_cat_downwards'] = 'Nadol?';
$PMF_LANG['ad_export_type'] = 'Formát výstupu';
$PMF_LANG['ad_export_type_choose'] = 'Zvoľte jeden z podporovaných formátov:';
$PMF_LANG['ad_export_download_view'] = 'Stiahnuť alebo zobraziť in-line?';
$PMF_LANG['ad_export_download'] = 'stiahnuť';
$PMF_LANG['ad_export_view'] = 'zobraziť in-line';
$PMF_LANG['ad_export_gen_xhtml'] = 'Vytvoriť XHTML súbor';
$PMF_LANG['ad_export_gen_docbook'] = 'Vytvoriť Docbook súbor';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'Dáta noviniek';
$PMF_LANG['ad_news_author_name'] = 'Meno autora:';
$PMF_LANG['ad_news_author_email'] = 'E-mail autora:';
$PMF_LANG['ad_news_set_active'] = 'Aktivovať';
$PMF_LANG['ad_news_allowComments'] = 'Povoliť komentáre:';
$PMF_LANG['ad_news_expiration_window'] = 'Okno pre zobrazenie doby platnosti noviniek (voliteľné)';
$PMF_LANG['ad_news_from'] = 'Od:';
$PMF_LANG['ad_news_to'] = 'Pre:';
$PMF_LANG['ad_news_insertfail'] = 'Počas vkladania novinky do databázy sa vyskytla chyba.';
$PMF_LANG['ad_news_updatefail'] = 'Počas aktualizácie novinky do databázy sa vyskytla chyba.';
$PMF_LANG['newsShowCurrent'] = 'Zobraziť aktuálne novinky.';
$PMF_LANG['newsShowArchive'] = 'Zobraziť staršie novinky.';
$PMF_LANG['newsArchive'] = ' Archív noviniek';
$PMF_LANG['newsWriteComment'] = 'komentovať položku';
$PMF_LANG['newsCommentDate'] = 'Pridané: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Okno pre zobrazenie doby vypršania záznamu (voliteľné)';
$PMF_LANG['adminHeaderDashboard'] = 'Dashboard';
$PMF_LANG['admin_mainmenu_users'] = 'Užívatelia';
$PMF_LANG['admin_mainmenu_content'] = 'Obsah';
$PMF_LANG['admin_mainmenu_statistics'] = 'Štatistiky';
$PMF_LANG['admin_mainmenu_backup'] = 'Záloha';
$PMF_LANG['admin_mainmenu_configuration'] = 'Konfigurácia';
$PMF_LANG['admin_mainmenu_logout'] = 'Odhlásenie';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Zakladateľ kategórie';
$PMF_LANG['adminSection'] = 'Administrácia';
$PMF_LANG['err_expiredArticle'] = 'Táto položka vypršala a nemôže byť zobrazená';
$PMF_LANG['err_expiredNews'] = 'Táto novinka vypršala a nemôže byť zobrazená';
$PMF_LANG['err_inactiveNews'] = 'Táto novinka sa upravuje a nemôže byť vymazaná';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Hľadať vo všetkých jazykoch:';
$PMF_LANG['ad_entry_tags'] = 'Tagy';
$PMF_LANG['msg_tags'] = 'Tagy';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'Súvisiace položky';
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "Počet súvisiacich položiek");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Preložiť';
$PMF_LANG['ad_categ_trans_2'] = 'Kategória';
$PMF_LANG['ad_categ_translatecateg'] = 'Preložiť kategóriu';
$PMF_LANG['ad_categ_translate'] = 'Preložiť';
$PMF_LANG['ad_categ_transalready'] = 'Už bolo preložené: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Vymazať vo všetkých jazykoch?';
$PMF_LANG["ad_categ_deletethislang"] = 'Vymazať iba v tomto jazyku?';
$PMF_LANG["ad_categ_translated"] = "Kategória bola preložená.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["msgCategoryMatrix"] = "Prehľad";
$PMF_LANG['ad_menu_categ_structure'] = "Prehľad kategórií a jazykov";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Oprávnenia užívateľov:';
$PMF_LANG['ad_entry_grouppermission'] = 'Oprávnenia skupiny:';
$PMF_LANG['ad_entry_all_users'] = 'Prístup pre všetkých užívateľov';
$PMF_LANG['ad_entry_restricted_users'] = 'Obmedzený prístup pre';
$PMF_LANG['ad_entry_all_groups'] = 'Prístup pre všetky skupiny';
$PMF_LANG['ad_entry_restricted_groups'] = 'Obmedzený prístup pre';
$PMF_LANG['ad_session_expiration'] = 'Čas do konca porady';
$PMF_LANG['ad_user_active'] = 'aktívny';
$PMF_LANG['ad_user_blocked'] = 'blokovaný';
$PMF_LANG['ad_user_protected'] = 'chránený';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Zvoľte FAQ záznam pre jeho vloženie ako odkaz...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Vložiť po";
$PMF_LANG["msgCategoryRemark_overview"] = "Správne poradie kategórií bude zobrazené vtedy, keď budú všetky kategórie definované pre aktuálny jazyk (prvý stĺpec).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d Hostia a %d Registrovaní';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Vymazať prihlásenia staršie ako 30 dní';
$PMF_LANG['ad_adminlog_delete_success'] = 'Staré prihlásenia úspešne vymazané.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Vyskytla sa chyba. Prihlásenia nevymazané.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['ad_quicklinks'] = 'Quicklinks';
$PMF_LANG['ad_quick_category'] = 'Pridať novú kategóriu';
$PMF_LANG['ad_quick_record'] = 'Pridať nový FAQ záznam';
$PMF_LANG['ad_quick_user'] = 'Pridať nového užívateľa';
$PMF_LANG['ad_quick_group'] = 'Pridať novú skupinu';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Návrh prekladu';
$PMF_LANG['msgNewTranslationAddon'] = 'Váš návrh nebude publikovaný ihneď, po obdržaní bude schválený administrátorom. Povinné položky sú <strong>Vaše meno</strong>, <strong>Váš e-mail</strong>, <strong>Názov prekladu</strong> a <strong>Váš FAQ preklad</strong>. Kľúčové slová prosím oddeľte iba medzerou.';
$PMF_LANG['msgNewTransSourcePane'] = 'Zdroj';
$PMF_LANG['msgNewTranslationPane'] = 'Preklad';
$PMF_LANG['msgNewTranslationName'] = "Vaše meno";
$PMF_LANG['msgNewTranslationMail'] = "Váš e-mail";
$PMF_LANG['msgNewTranslationKeywords'] = "Kľúčové slová";
$PMF_LANG['msgNewTranslationSubmit'] = 'Potvrdiť Váš návrh';
$PMF_LANG['msgTranslate'] = 'Navrhnúť preklad pre';
$PMF_LANG['msgTranslateSubmit'] = 'Začať prekladať...';
$PMF_LANG['msgNewTranslationThanks'] = "Ďakujeme za Váš návrh prekladu!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG['permission::addgroup'] = "pridať konto pre skupinu";
$PMF_LANG['permission::editgroup'] = "upraviť kontá pre skupiny";
$PMF_LANG['permission::delgroup'] = "vymazať kontá pre skupiny";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Odkazy otvoriť v nadradenom okne';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Komentáre';
$PMF_LANG['adminHeaderComments'] = 'Komentáre správy';
$PMF_LANG['msgAdminCommentFaqs'] = 'Komentáre v záznamoch FAQ:';
$PMF_LANG['msgAdminCommentNews'] = 'Komentáre v záznamoch noviniek:';
$PMF_LANG['ad_groups'] = 'Skupiny';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array('select', 'Triedenie záznamov (podľa zakladateľa)');
$LANG_CONF['records.sortby'] = array('select', 'Triedenie záznamov (zostupne alebo vzostupne)');
$PMF_LANG['ad_conf_order_id'] = 'ID (prednastavené)';
$PMF_LANG['ad_conf_order_thema'] = 'Názov';
$PMF_LANG['ad_conf_order_visits'] = 'Počet návštev';
$PMF_LANG['ad_conf_order_updated'] = 'Dátum';
$PMF_LANG['ad_conf_order_author'] = 'Autor';
$PMF_LANG['ad_conf_desc'] = 'zostupne';
$PMF_LANG['ad_conf_asc'] = 'vzostupne';
$PMF_LANG['mainControlCenter'] = 'Hlavné nastavenia';
$PMF_LANG['recordsControlCenter'] = 'Nastavenia FAQ záznamov';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array("checkbox", "Aktivovať nový záznam (prednastavené: deaktivované)");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "Povoliť komentáre pre nové záznamy (prednastavené: nepovoliť)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Záznamy v tejto kategórii';
$PMF_LANG['msgTagSearch'] = 'Označené položky';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Informácie';
$PMF_LANG['msgOnlineVersionCheck'] = 'Kontrola online verzie';
$PMF_LANG['ad_system_info'] = 'Systémové Informácie';

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG['msgRegisterUser'] = 'Chcete sa zaregistrovať?';
$PMF_LANG["msgUsername"] = 'Prihlasovacie meno:';
$PMF_LANG['errorRegistration'] = 'Toto pole je povinné!';
$PMF_LANG['submitRegister'] = 'Zaregistrovať';
$PMF_LANG['msgUserData'] = 'Užívateľské informácie potrebné pre registráciu';
$PMF_LANG['captchaError'] = 'Prosím vložte správny captcha kód!';
$PMF_LANG['msgRegError'] = 'Chyby pretrvávajú. Prosím opravte ich:';
$PMF_LANG['successMessage'] = 'Vaša registrácia bola úspešná. Najprv obdržíte potvrdzujúci e-mail s prihlasovacími údajmi!';
$PMF_LANG['msgRegThankYou'] = 'Ďakujeme za Vašu registráciu';
$PMF_LANG['emailRegSubject'] = '[%sitename%] Registrácia: nový užívateľ';

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG['msgMostPopularSearches'] = 'Najčastejšie vyhľadávania sú:';
$LANG_CONF['main.enableWysiwygEditor'] = array("checkbox", "Povoliť WYSIWYG editor (prednastavené: povoliť)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG['ad_menu_searchstats'] = 'Štatistiky vyhľadávania';
$PMF_LANG['ad_searchstats_search_term'] = 'Kľúčové slová';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Počet';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Jazyk';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Percento';

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG['ad_record_sticky'] = 'Otravné';
$PMF_LANG['ad_entry_sticky'] = 'Otravné';
$PMF_LANG['stickyRecordsHeader'] = 'Otravné FAQ';

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Stop Words';
$PMF_LANG['ad_config_stopword_input'] = 'Pridať nové stop word';

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG['msgSendMailDespiteEverything'] = 'Nie, stále sa nenašla adekvátna odpoveď (poslať e-mail)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'Je hľadaná odpoveď zobrazená vo výsledkoch?';

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Prosím vyberte jazyk prekladu';
$PMF_LANG['msgLangDirIsntWritable'] = 'Preklady dir nie sú zapisovateľné';
$PMF_LANG['ad_menu_translations'] = 'Rozhranie prekladu';
$PMF_LANG['ad_start_notactive'] = 'Čaká sa na aktiváciu';

// added 2.5.0-RC - 2009-05-20 by Anatoliy
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Pridať nový preklad';
$PMF_LANG['msgTransToolLanguage'] = 'Jazyk';
$PMF_LANG['msgTransToolActions'] = 'Akcie';
$PMF_LANG['msgTransToolWritable'] = 'Zapisovateľné';
$PMF_LANG['msgEdit'] = 'Upraviť';
$PMF_LANG['msgDelete'] = 'Vymazať';
$PMF_LANG['msgYes'] = 'áno';
$PMF_LANG['msgNo'] = 'nie';
$PMF_LANG['msgVariable'] = 'Nastaviteľné';
$PMF_LANG['msgCancel'] = 'Cancel';
$PMF_LANG['msgSave'] = 'Ulož';
$PMF_LANG['msgSaving3Dots'] = 'ukladanie ...';
$PMF_LANG['msgRemoving3Dots'] = 'odstraňovanie ...';
$PMF_LANG['msgLanguage'] = 'Jazyk';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Kódovanie jazyka';
$PMF_LANG['msgTransToolLanguageDir'] = 'Kontrola jazyka';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Popis jazyka';
$PMF_LANG['msgAuthor'] = 'Autor';
$PMF_LANG['msgTransToolAddAuthor'] = 'Pridať autora';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Vytvoriť preklad';
$PMF_LANG['msgTransToolTransCreated'] = 'Nový preklad úspešne vytvorený';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Nemožno vytvoriť nový preklad';
$PMF_LANG['msgAdding3Dots'] = 'pridávanie ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Poslať pre phpMyFAQ team';
$PMF_LANG['msgSending3Dots'] = 'posiela sa ...';
$PMF_LANG['msgTransToolFileSent'] = 'Jazykový súbor bol úspešne odoslaný pre phpMyFAQ team. Ďakujeme za účasť.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Počas posielania jazykového súboru sa vyskytla chyba';
$PMF_LANG['msgTransToolPercent'] = 'Percento';

// added 2.5.0-RC3 - 2009-06-23 by Anatoliy
$LANG_CONF['records.attachmentsPath'] = array("input", "Cesta k uloženým prílohám.<br><small>Relative path means a folder within web root</small>");

// added 2.5.0-RC3 - 2009-06-24 by Anatoliy
$PMF_LANG['msgAttachmentNotFound'] = "Súbor, ktorý sa pokúšate stiahnuť nebol na tomto serveri nájdený.";
$PMF_LANG['ad_sess_noentry'] = "Vstup zakázaný";

// added 2.6.0-alpha - 2009-07-30 by Aurimas Fišeras
//P.S. "One User online" is also possible, since sprintf just ignores extra args
$PMF_LANG["plmsgUserOnline"][0] = "%d užívateľ online";
$PMF_LANG["plmsgUserOnline"][1] = "%d užívatelia online";

// added 2.6.0-alpha - 2009-08-02 by Anatoliy
$LANG_CONF['layout.templateSet'] = array("select", "Šablóna nastavená na použitie");

// added 2.6.0-alpha - 2009-08-16 by Aurimas Fišeras - Plural messages
$PMF_LANG["plmsgHomeArticlesOnline"][0] = "Je tu %d FAQ online";
$PMF_LANG["plmsgHomeArticlesOnline"][1] = "Sú tu %d FAQ online";
$PMF_LANG["plmsgViews"][0] = "%d zobrazenie";
$PMF_LANG["plmsgViews"][1] = "%d zobrazenia";

// added 2.6.0-alpha - 2009-08-30 by Aurimas Fišeras - Plural messages
$PMF_LANG['plmsgGuestOnline'][0] = '%d Hosť';
$PMF_LANG['plmsgGuestOnline'][1] = '%d Hostia';
$PMF_LANG['plmsgRegisteredOnline'][0] = ' a %d Registrovaný';
$PMF_LANG['plmsgRegisteredOnline'][1] = ' a %d Registrovaní';
$PMF_LANG["plmsgSearchAmount"][0] = "%d výsledok hľadania";
$PMF_LANG["plmsgSearchAmount"][1] = "%d výsledky hľadania";
$PMF_LANG["plmsgPagesTotal"][0] = " %d Strana";
$PMF_LANG["plmsgPagesTotal"][1] = " %d Strany";
$PMF_LANG["plmsgVotes"][0] = "%d Hlas";
$PMF_LANG["plmsgVotes"][1] = "%d Hlasy";
$PMF_LANG["plmsgEntries"][0] = "%d FAQ";
$PMF_LANG["plmsgEntries"][1] = "%d FAQ";

// added 2.6.0-alpha - 2009-09-06 by Aurimas Fišeras
$PMF_LANG['permission::addtranslation'] = "pridať preklad";
$PMF_LANG['permission::edittranslation'] = "upraviť preklad";
$PMF_LANG['permission::deltranslation'] = "vymazať preklad";
$PMF_LANG['permission::approverec'] = "schváliť záznamy";

// added 2.6.0-alpha - 2009-09-9 by Anatoliy Belsky
$LANG_CONF["records.enableAttachmentEncryption"] = array("checkbox", "Povoliť šifrovanie príloh <br><small>Ignorovať, keď sú prílohy nepovolené</small>");
$LANG_CONF["records.defaultAttachmentEncKey"] = array("input", 'Predvolený šifrovací kľúč príloh <br><small>Ignorovať, keď je šifrovanie príloh nepovolené</small><br><small><font color="red">WARNING: Toto nastavenie nemeňte, pokiaľ ste už povolili šifrovanie súborov!!!</font></small>');

// added 2.6.0-alpha - 2009-09-06 by Thorsten
$PMF_LANG['ad_menu_upgrade'] = 'phpMyFAQ Upgrade';
$PMF_LANG['ad_you_shouldnt_update'] = 'Máte najnovšiu verziu phpMyFAQ. Teraz nepotrebujete upgrade.';
$LANG_CONF['security.useSslForLogins'] = array('checkbox', "Povoliť iba prihlásenia cez zabezpečené pripojenie? (prednastavené: nepovoliť)");
$PMF_LANG['msgSecureSwitch'] = "Prepnúť na bezpečný mód pre prihlásenie!";

// added 2.6.0-alpha - 2009-10-03 by Anatoliy Belsky
$PMF_LANG['msgTransToolNoteFileSaving'] = 'Majte prosím na pamäti, že ak dokument neuložíte, žiadne nové údaje nebudú zapísané';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'Strana %d nahrávanie úspešné';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'Chyba pri nahrávaní strany %d ';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'Nahrávanie strany %d ';

// added 2.6.0-alpha - 2009-11-02 by Anatoliy Belsky
$PMF_LANG['ad_record_active'] = 'Aktívny';

// added 2.6.0-alpha - 2009-11-01 by Anatoliy Belsky
$PMF_LANG['msgAttachmentInvalid'] = 'Príloha je chybná, prosím informujte administrátora';

// added 2.6.0-alpha - 2009-11-02 by max
$LANG_CONF['search.numberSearchTerms'] = array("input", 'Počet nájdených položiek');
$LANG_CONF['records.orderingPopularFaqs'] = array("select", "Triedenie top FAQ");
$PMF_LANG['list_all_users'] = 'Zobraziť všetkých užívateľov';

$PMF_LANG['records.orderingPopularFaqs.visits'] = "zobraziť najnavštevovanejšie položky";
$PMF_LANG['records.orderingPopularFaqs.voting'] = "zobraziť najviac hodnotené položky";

// added 2.6.0-alpha - 2009-11-05 by Thorsten
$PMF_LANG['msgShowHelp'] = 'Prosím oddeľte slová čiarkou.';

// added 2.6.0-RC - 2009-11-30 by Thorsten
$PMF_LANG['msgUpdateFaqDate'] = 'aktualizovať';
$PMF_LANG['msgKeepFaqDate'] = 'ponechať';
$PMF_LANG['msgEditFaqDat'] = 'upraviť';

return $PMF_LANG;
