<?php

/**
 * Bangla language file - try to be the best of Bangladeshi Bangla
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package   phpMyFAQ
 * @author    Md. Masum Billah <jewelurp@dhaka.net>
 * @copyright 2008-2024 phpMyFAQ Team
 * @license   https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      https://www.phpmyfaq.de
 * @since     2008-04-01
 * @codingStandardsIgnoreFile
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "bn";
$PMF_LANG["language"] = "bangla";
$PMF_LANG['direction'] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "বিভাগ";
$PMF_LANG["msgShowAllCategories"] = "সব বিভাগ দেখুন";
$PMF_LANG["msgSearch"] = "অনুসন্ধান";
$PMF_LANG["msgAddContent"] = "লেখা যোগ করুন";
$PMF_LANG["msgQuestion"] = "প্রশ্ন করুন";
$PMF_LANG["msgOpenQuestions"] = "উত্তরের অপেক্ষায়";
$PMF_LANG["msgHelp"] = "সাহায্য";
$PMF_LANG["msgContact"] = "যোগাযোগ";
$PMF_LANG["msgHome"] = "প্রথম পাতা";
$PMF_LANG["msgNews"] = "প্রশ্ন উত্তর-খবর";
$PMF_LANG["msgUserOnline"] = " জন নিবন্ধিত ব্যবহারকারি";
$PMF_LANG["msgXMLExport"] = "এক্স এম এল ফাইল";
$PMF_LANG["msgBack2Home"] = "প্রথম পাতায় ফেরত যান";

// Contentpages
$PMF_LANG["msgFullCategories"] = "মোট প্রশ্ন সহ বিভাগ";
$PMF_LANG["msgFullCategoriesIn"] = "প্রশ্ন -> বিভাগ";
$PMF_LANG["msgSubCategories"] = "উপ বিভাগ";
$PMF_LANG["msgEntries"] = "প্রশ্ন";
$PMF_LANG["msgEntriesIn"] = "প্রশ্ন -> ";
$PMF_LANG["msgViews"] = "জন দেখেছেন";
$PMF_LANG["msgPage"] = "পাতা ";
$PMF_LANG["msgPages"] = " পাতা";
$PMF_LANG["msgPrevious"] = "আগে";
$PMF_LANG["msgNext"] = "পরে";
$PMF_LANG["msgCategoryUp"] = "এক বিভাগ উপরে";
$PMF_LANG["msgLastUpdateArticle"] = "শেষ হালনাগাদ: ";
$PMF_LANG["msgAuthor"] = "লেখক: ";
$PMF_LANG["msgPrinterFriendly"] = "মুদ্রণ উপযোগি";
$PMF_LANG["msgPrintArticle"] = "প্রশ্নটি মুদ্রণ করুন";
$PMF_LANG["msgMakeXMLExport"] = "এক্স এম এল হিসাবে সংরক্ষন করুন";
$PMF_LANG["msgAverageVote"] = "মোট নম্বর";
$PMF_LANG["msgVoteUsability"] = "নম্বর দিন";
$PMF_LANG["msgVoteFrom"] = "মধ্যে";
$PMF_LANG["msgVoteBad"] = "ব্যবহার যোগ্য নয়";
$PMF_LANG["msgVoteGood"] = "মুল্যবান";
$PMF_LANG["msgVotings"] = "ভোট ";
$PMF_LANG["msgVoteSubmit"] = "ভোট দিন";
$PMF_LANG["msgVoteThanks"] = "ভোট দেয়ার জন্য ধন্যবাদ!";
$PMF_LANG["msgYouCan"] = "";
$PMF_LANG["msgWriteComment"] = "প্রশ্নটি সম্পর্কে মতামত দিন";
$PMF_LANG["msgShowCategory"] = "বিভাগ সংক্ষেপ: ";
$PMF_LANG["msgCommentBy"] = "মতামত প্রদানকারি ";
$PMF_LANG["msgCommentHeader"] = "মতামত দিন";
$PMF_LANG["msgYourComment"] = "আপনার মতামত";
$PMF_LANG["msgCommentThanks"] = "মতামত দেয়ার জন্য ধন্যবাদ!";
$PMF_LANG["msgSend2Friend"] = "বন্ধুকে পাঠান";
$PMF_LANG["msgS2FButton"] = "ই-মেইল পাঠান";

// Search
$PMF_LANG["msgSearchWord"] = "শব্দ";
$PMF_LANG["msgSearchFind"] = "ফলাফল ";
$PMF_LANG["msgSearchAmount"] = " ফলাফল";
$PMF_LANG["msgSearchAmounts"] = " ফলাফল সমূহ";
$PMF_LANG["msgSearchCategory"] = "বিভাগ: ";
$PMF_LANG["msgSearchContent"] = "প্রশ্ন: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "প্রশ্ন উত্তর সম্পর্কে মতামত";
$PMF_LANG["msgNewContentAddon"] = "আপনার পরামর্শ অবিলম্বে প্রদর্শিত হবে না, কিন্তু প্রকাশের আগে আমাদের দ্বারা চেক করা হবে. বাধ্যতামূলক ক্ষেত্র হল * দিয়ে চিহ্নিত ক্ষেত্র।";
$PMF_LANG["msgNewContentName"] = "আপনার নাম";
$PMF_LANG["msgNewContentMail"] = "আপনার ই-মেইল ঠিকানা";
$PMF_LANG["msgNewContentCategory"] = "বিভাগ";
$PMF_LANG["msgNewContentTheme"] = "হেল্পলাইন";
$PMF_LANG["msgNewContentArticle"] = "আপনার উত্তর";
$PMF_LANG["msgNewContentKeywords"] = "চাবিশব্দ";
$PMF_LANG["msgNewContentLink"] = "প্রশ্নটির সাথে সর্ম্পকিত লিংক";
$PMF_LANG["msgNewContentSubmit"] = "জমা দিন";
$PMF_LANG["msgInfo"] = "আরো তথ্য: ";
$PMF_LANG["msgNewContentThanks"] = "পরার্মশের জন্য ধন্যবাদ!";
$PMF_LANG["msgNoQuestionsAvailable"] = "র্বতমানে উত্তরের অপেক্ষায় কোন প্রশ্ন নেই।";

// ask Question
$PMF_LANG["msgNewQuestion"] = "নীচে আপনার প্রশ্ন লিখুন";
$PMF_LANG["msgAskCategory"] = "বিভাগ";
$PMF_LANG["msgAskYourQuestion"] = "আপনার প্রশ্ন";
$PMF_LANG["msgAskThx4Mail"] = "<h2>প্রশ্নের জন্য ধন্যবাদ!</h2>";
$PMF_LANG["msgDate_User"] = "তারিখ / ব্যবহারকারী";
$PMF_LANG["msgQuestion2"] = "প্রশ্ন";
$PMF_LANG["msg2answer"] = "উত্তর";
$PMF_LANG["msgQuestionText"] = "এখানে আপনি অন্য ব্যবহারকারীর প্রশ্ন দেখতে পারেন। আপনি কোন প্রশ্নের উত্তর দিলে তা প্রশ্ন-উত্তর তালিকায় আসার সম্ভাবনা আছে।";

// Help
$PMF_LANG["msgHelpText"] = "প্রশ্ন-উত্তর তালিকার কাঠামো খুবই সরল। আপনি <strong><a href=\"?action=show\">বিভাগ</a></strong> অনুসারে খুঁজতে পারেন অথবা প্রশ্ন-উত্তর তালিকা <strong><a href=\"?action=search\">অনুসন্ধান ব্যবস্থা</a></strong> ব্যবহার করে আপনার ইচ্ছা মত শব্দ দিয়ে খুঁজতে পারেন।";

// Contact
$PMF_LANG["msgContactEMail"] = "ওয়েবমাস্টারকে ই-মেইল করুন";
$PMF_LANG["msgMessage"] = "আপনার তথ্য";

// Startseite
$PMF_LANG["msgNews"] = " খবর";
$PMF_LANG["msgTopTen"] = "সেরা ১০ প্রশ্ন";
$PMF_LANG["msgHomeThereAre"] = "এখানে ";
$PMF_LANG["msgHomeArticlesOnline"] = "টি প্রশ্ন অনলাইনে আছে";
$PMF_LANG["msgNoNews"] = "কোন খবর নেই।";
$PMF_LANG["msgLatestArticles"] = "শেষ ৫টি প্রশ্ন";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "পরার্মশের জন্য ধন্যবাদ।";
$PMF_LANG["msgMailCheck"] = "প্রশ্ন-উত্তর তালিকায় একটি নতুন প্রশ্ন এসেছে!প্রশাসকের অংশে দেখুন!";
$PMF_LANG["msgMailContact"] = "আপনার প্রশ্ন প্রশাসকের কাছে পাঠানো হয়েছে।";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "ডাটাবেজ সংযোগ নেই।";
$PMF_LANG["err_noHeaders"] = "কোনো বিভাগ পাওয়া যায় নি";
$PMF_LANG["msgErrorNoRecords"] = "কোনো লেখা পাওয়া যায়নি।";
$PMF_LANG["err_badID"] = "ভুল পরিচয়।";
$PMF_LANG["err_noTopTen"] = "সেরা ১০ টি প্রশ্ন পাওয়া যায়নি।";
$PMF_LANG["err_nothingFound"] = "কোনো প্রশ্ন পাওয়া যায়নি।";
$PMF_LANG["err_SaveEntries"] = "প্রয়োজনীয় ফিল্ড হল <strong>আপনার নাম</strong>, <strong>আপনার ই-মেইল ঠিকানা</strong>, <strong>বিভাগ</strong>, <strong>শিরনাম</strong>, <strong>আপনার লেখা</strong><strong>আপনার প্রশ্ন</strong><a href=\"javascript:history.back();\">আগের পাতায় ফেরত যান</a><br><br>";
$PMF_LANG["err_VoteTooMuch"] = "একাধিক ভোট দেয়া যায়না। আগের পাতায় ফেরত যান";
$PMF_LANG["err_noVote"] = "<strong>আপনি এই প্রশ্নটিতে নম্বর দিতে পারবেন না!</strong> <a href=\"javascript:history.back();\">আগের পাতায় ফেরত যান।</a>";
$PMF_LANG["err_noMailAdress"] = "Your email address is not correct.<br><a href=\"javascript:history.back();\">back</a>";
$PMF_LANG["err_sendMail"] = "প্রয়োজনীয় ফিল্ড হল <strong>আপনার নাম</strong>, <strong>আপনার ই-মেইল ঠিকানা</strong>, <strong>আপনার প্রশ্ন</strong><a href=\"javascript:history.back();\">আগের পাতায় ফেরত যান</a><br><br>";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>প্রশ্ন-উত্তর তালিকা খুঁজুন:</strong><br>একটির বেশী শব্দ ব্যবহার করে আপনি খুঁজতে পারেন।<strong>নোটিশ:</strong> শব্দটি কমপক্ষে চার অক্ষরের হতে হবে।";

// Menü
$PMF_LANG["ad"] = "ADMIN SECTION";
$PMF_LANG["ad_menu_user_administration"] = "Users";
$PMF_LANG["ad_menu_entry_aprove"] = "Approve FAQs";
$PMF_LANG["ad_menu_entry_edit"] = "Edit FAQs";
$PMF_LANG["ad_menu_categ_add"] = "Add Entity";
$PMF_LANG["msgHeaderCategoryOverview"] = "Edit Entity";
$PMF_LANG["ad_menu_news_add"] = "Add News";
$PMF_LANG["ad_menu_news_edit"] = "Edit News";
$PMF_LANG["ad_menu_open"] = "Open questions";
$PMF_LANG["ad_menu_stat"] = "Statistics";
$PMF_LANG["ad_menu_cookie"] = "Set cookies";
$PMF_LANG["ad_menu_session"] = "View Sessions";
$PMF_LANG["ad_menu_adminlog"] = "View Adminlog";
$PMF_LANG["ad_menu_passwd"] = "Change Password";
$PMF_LANG["ad_menu_logout"] = "লগ আউট";
$PMF_LANG["ad_menu_startpage"] = "Startpage";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Please identify yourself.";
$PMF_LANG["ad_msg_passmatch"] = "Both passwords must match!";
$PMF_LANG["ad_msg_savedsuc_1"] = "The profile of";
$PMF_LANG["ad_msg_savedsuc_2"] = "was saved successfully.";
$PMF_LANG["ad_msg_mysqlerr"] = "Due to a <strong>database error</strong>, the profile could not be saved.";
$PMF_LANG["ad_msg_noauth"] = "You are not authorized.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Page";
$PMF_LANG["ad_gen_of"] = "of";
$PMF_LANG["ad_gen_lastpage"] = "Previous Page";
$PMF_LANG["ad_gen_nextpage"] = "Next Page";
$PMF_LANG["ad_gen_save"] = "Save";
$PMF_LANG["ad_gen_reset"] = "Reset";
$PMF_LANG["ad_gen_yes"] = "Yes";
$PMF_LANG["ad_gen_no"] = "No";
$PMF_LANG["ad_gen_top"] = "Top of page";
$PMF_LANG["ad_gen_ncf"] = "No category found!";
$PMF_LANG["ad_gen_delete"] = "Delete";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "User Administration";
$PMF_LANG["ad_user_username"] = "Registered users";
$PMF_LANG["ad_user_rights"] = "User Rights";
$PMF_LANG["ad_user_edit"] = "edit";
$PMF_LANG["ad_user_delete"] = "delete";
$PMF_LANG["ad_user_add"] = "Add User";
$PMF_LANG["ad_user_profou"] = "Profile of the user";
$PMF_LANG["ad_user_name"] = "Name";
$PMF_LANG["ad_user_password"] = "Password";
$PMF_LANG["ad_user_confirm"] = "Confirm";
$PMF_LANG["ad_user_rights"] = "Rights";
$PMF_LANG["ad_user_del_1"] = "The User";
$PMF_LANG["ad_user_del_2"] = "shall be deleted?";
$PMF_LANG["ad_user_del_3"] = "Are you sure?";
$PMF_LANG["ad_user_deleted"] = "The user was successfully deleted.";
$PMF_LANG["ad_user_checkall"] = "Select all";

// Beitragsverwaltung
$PMF_LANG["msgHeaderFAQOverview"] = "Administration of Records";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Topic";
$PMF_LANG["ad_entry_action"] = "Action";
$PMF_LANG["ad_entry_edit_1"] = "Edit Record";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Question";
$PMF_LANG["ad_entry_content"] = "Answer";
$PMF_LANG["ad_entry_keywords"] = "Keywords";
$PMF_LANG["ad_entry_author"] = "Author";
$PMF_LANG["ad_entry_category"] = "Entity";
$PMF_LANG["ad_entry_active"] = "Active?";
$PMF_LANG["ad_entry_date"] = "Date";
$PMF_LANG["ad_entry_status"] = "FAQ Status";
$PMF_LANG["ad_entry_changed"] = "Changed?";
$PMF_LANG["ad_entry_changelog"] = "Changelog";
$PMF_LANG["ad_entry_commentby"] = "Comment by";
$PMF_LANG["ad_entry_comment"] = "Comments";
$PMF_LANG["ad_entry_save"] = "Save";
$PMF_LANG["msgDelete"] = "delete";
$PMF_LANG["ad_entry_delcom_1"] = "Are you sure that the comment of the user";
$PMF_LANG["ad_entry_delcom_2"] = "should be deleted?";
$PMF_LANG["ad_entry_commentdelsuc"] = "The comment was <strong>successfully</strong> deleted.";
$PMF_LANG["ad_entry_back"] = "Back to the article";
$PMF_LANG["ad_entry_commentdelfail"] = "The comment was <strong>not</strong> deleted.";
$PMF_LANG["ad_entry_savedsuc"] = "The changes were saved <strong>successfully</strong>.";
$PMF_LANG["ad_entry_savedfail"] = "Unfortunately, a <strong>database error</strong> occurred.";
$PMF_LANG["ad_entry_del_1"] = "Are you sure that the topic";
$PMF_LANG["ad_entry_del_2"] = "of";
$PMF_LANG["ad_entry_del_3"] = "should be deleted?";
$PMF_LANG["ad_entry_delsuc"] = "Issue <strong>successfully</strong> deleted.";
$PMF_LANG["ad_entry_delfail"] = "Issue was <strong>not deleted</strong>!";
$PMF_LANG["ad_entry_back"] = "Back";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Article header";
$PMF_LANG["ad_news_text"] = "Text of the Record";
$PMF_LANG["ad_news_link_url"] = "Link (<strong>without https://</strong>)";
$PMF_LANG["ad_news_link_title"] = "Title of the link";
$PMF_LANG["ad_news_link_target"] = "Target of the link";
$PMF_LANG["ad_news_link_window"] = "Link opens new window";
$PMF_LANG["ad_news_link_faq"] = "Link within the FAQ";
$PMF_LANG["ad_news_add"] = "Add News";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Headline";
$PMF_LANG["ad_news_date"] = "Date";
$PMF_LANG["ad_news_action"] = "Action";
$PMF_LANG["ad_news_update"] = "update";
$PMF_LANG["ad_news_delete"] = "delete";
$PMF_LANG["ad_news_nodata"] = "No data found in database";
$PMF_LANG["ad_news_updatesuc"] = "The News were updated.";
$PMF_LANG["ad_news_del"] = "Are you sure that you want to delete this news item?";
$PMF_LANG["ad_news_yesdelete"] = "yes, delete!";
$PMF_LANG["ad_news_nodelete"] = "no!";
$PMF_LANG["ad_news_delsuc"] = "News item deleted.";
$PMF_LANG["ad_news_updatenews"] = "News item updated.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Add new category";
$PMF_LANG["ad_categ_catnum"] = "Entity Number";
$PMF_LANG["ad_categ_subcatnum"] = "Subcategory Number";
$PMF_LANG["ad_categ_nya"] = "<em>not yet available!</em>";
$PMF_LANG["ad_categ_titel"] = "Entity Title";
$PMF_LANG["ad_categ_add"] = "Add Entity";
$PMF_LANG["ad_categ_existing"] = "Existing Categories";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Entity";
$PMF_LANG["ad_categ_subcateg"] = "Subcategory";
$PMF_LANG["ad_categ_titel"] = "Entity title";
$PMF_LANG["ad_categ_action"] = "Action";
$PMF_LANG["ad_categ_update"] = "update";
$PMF_LANG["ad_categ_delete"] = "delete";
$PMF_LANG["ad_categ_updatecateg"] = "Update Entity";
$PMF_LANG["ad_categ_nodata"] = "No data found in database";
$PMF_LANG["msgCategoryRemark"] = "Please note that existing entries will not be visible anymore, if you delete the category. You must assign a new category for the article or delete the article.";
$PMF_LANG["ad_categ_edit_1"] = "Edit";
$PMF_LANG["ad_categ_edit_2"] = "Entity";
$PMF_LANG["ad_categ_add"] = "add Entity";
$PMF_LANG["ad_categ_added"] = "The category was added.";
$PMF_LANG["ad_categ_updated"] = "The category was updated.";
$PMF_LANG["ad_categ_del_yes"] = "yes, delete!";
$PMF_LANG["ad_categ_del_no"] = "no!";
$PMF_LANG["ad_categ_deletesure"] = "Are you sure to delete this category?";
$PMF_LANG["ad_categ_deleted"] = "Entity deleted.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc 	"] = "The Cookie was <strong>successfully</strong> set.";
$PMF_LANG["ad_cookie_already"] = "A cookie was set already. You now have following options";
$PMF_LANG["ad_cookie_again"] = "Set cookie again";
$PMF_LANG["ad_cookie_delete"] = "delete cookie";
$PMF_LANG["ad_cookie_no"] = "There is no cookie saved yet. With a cookie you could save your login script, thus no need to remember your login details again. You now have following options";
$PMF_LANG["ad_cookie_set"] = "Set cookie";
$PMF_LANG["ad_cookie_deleted"] = "Cookie deleted successfully.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "AdminLog";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Change your Password";
$PMF_LANG["ad_passwd_old"] = "Old password";
$PMF_LANG["ad_passwd_new"] = "New password";
$PMF_LANG["ad_passwd_con"] = "Confirm";
$PMF_LANG["ad_passwd_change"] = "Change password";
$PMF_LANG["ad_passwd_suc"] = "Password changed successfully.";
$PMF_LANG["ad_passwd_remark"] = "<strong>ATTENTION:</strong><br>Cookie have to be set again!";
$PMF_LANG["ad_passwd_fail"] = "The old password must be entered correctly and both new ones have to match.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Add user";
$PMF_LANG["ad_adus_name"] = "Name";
$PMF_LANG["ad_adus_password"] = "Password";
$PMF_LANG["ad_adus_add"] = "Add user";
$PMF_LANG["ad_adus_suc"] = "User <strong>successfully</strong> added.";
$PMF_LANG["ad_adus_edit"] = "Edit profile";
$PMF_LANG["ad_adus_dberr"] = "<strong>database error!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Username <strong>exists</strong> already.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "Session ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Time";
$PMF_LANG["ad_sess_pageviews"] = "PageViews";
$PMF_LANG["ad_sess_search"] = "Search";
$PMF_LANG["ad_sess_sfs"] = "Search for sessions";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "min. actions";
$PMF_LANG["ad_sess_s_date"] = "Date";
$PMF_LANG["ad_sess_s_after"] = "after";
$PMF_LANG["ad_sess_s_before"] = "before";
$PMF_LANG["ad_sess_s_search"] = "Search";
$PMF_LANG["ad_sess_session"] = "Session";
$PMF_LANG["ad_sess_r"] = "Search results for";
$PMF_LANG["ad_sess_referer"] = "Referer";
$PMF_LANG["ad_sess_browser"] = "Browser";
$PMF_LANG["ad_sess_ai_rubrik"] = "Entity";
$PMF_LANG["ad_sess_ai_artikel"] = "Record";
$PMF_LANG["ad_sess_ai_sb"] = "Search-Strings";
$PMF_LANG["ad_sess_ai_sid"] = "Session ID";
$PMF_LANG["ad_sess_back"] = "Back";

// Statistik
$PMF_LANG["ad_rs"] = "Rating Statistics";
$PMF_LANG["ad_rs_rating_1"] = "The ranking of";
$PMF_LANG["ad_rs_rating_2"] = "users shows";
$PMF_LANG["ad_rs_red"] = "Red";
$PMF_LANG["ad_rs_green"] = "Green";
$PMF_LANG["ad_rs_altt"] = "with an average lower than 20%";
$PMF_LANG["ad_rs_ahtf"] = "with an average higher than 80%";
$PMF_LANG["ad_rs_no"] = "No ranking available";

// Auth
$PMF_LANG["ad_auth_insert"] = "আপনার পরিচয় ও গোপন সংকেত দিন।";
$PMF_LANG["ad_auth_user"] = "পরিচয়";
$PMF_LANG["ad_auth_passwd"] = "গোপন সংকেত";
$PMF_LANG["ad_auth_ok"] = "জমা দিন";
$PMF_LANG["ad_auth_reset"] = "রিসেট করুন";
$PMF_LANG["ad_auth_fail"] = "পরিচয় অথবা চাবিশব্দ ঠিক নেই।";
$PMF_LANG["ad_auth_sess"] = "সেশন শেষ।";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Edit configuration";
$PMF_LANG["ad_config_save"] = "Save configuration";
$PMF_LANG["ad_config_reset"] = "Reset";
$PMF_LANG["ad_config_saved"] = "The configuration has been saved successfully.";
$PMF_LANG["ad_menu_editconfig"] = "Edit configuration";
$PMF_LANG["ad_att_none"] = "No attachments available";
$PMF_LANG["ad_att_att"] = "Attachments";
$PMF_LANG["ad_att_add"] = "Attach file";
$PMF_LANG["ad_entryins_suc"] = "Record successfully saved.";
$PMF_LANG["ad_entryins_fail"] = "An error occurred.";
$PMF_LANG["ad_att_del"] = "Delete";
$PMF_LANG["ad_att_nope"] = "Attachments can be added only while editing.";
$PMF_LANG["ad_att_delsuc"] = "The attachment has been deleted successfully.";
$PMF_LANG["ad_att_delfail"] = "An error occurred while deleting the attachment.";
$PMF_LANG["ad_entry_add"] = "Add FAQ";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "> A backup is a complete image of the database content. The format of the backup is a SQL transaction file, which can be imported using tools like phpMyAdmin or the commandline sql client. A backup should be performed at least once a month.";
$PMF_LANG["ad_csv_link"] = "Download the backup";
$PMF_LANG["ad_csv_head"] = "Make a backup";
$PMF_LANG["ad_att_addto"] = "Add an attachment to the issue";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "File";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "The file has been attached successfully.";
$PMF_LANG["ad_att_fail"] = "An error occurred while attaching the file.";
$PMF_LANG["ad_att_close"] = "Close this window";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "With this form you can restore the content of the database, using a backup made with phpmyfaq. Please note that the existing data will be overwritten.";
$PMF_LANG["ad_csv_file"] = "File";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "backup LOGs";
$PMF_LANG["ad_csv_linkdat"] = "backup data";
$PMF_LANG["ad_csv_head2"] = "Restore";
$PMF_LANG["ad_csv_no"] = "This does not seem to be a backup of phpmyfaq.";
$PMF_LANG["ad_csv_prepare"] = "Preparing the database queries...";
$PMF_LANG["ad_csv_process"] = "Querying...";
$PMF_LANG["ad_csv_of"] = "of";
$PMF_LANG["ad_csv_suc"] = "were successful.";
$PMF_LANG["ad_csv_backup"] = "Backup";
$PMF_LANG["ad_csv_rest"] = "Restore a backup";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Backup";
$PMF_LANG["ad_logout"] = "Session successfully terminated.";
$PMF_LANG["ad_news_add"] = "Add news";
$PMF_LANG["ad_news_edit"] = "Edit news";
$PMF_LANG["ad_cookie"] = "Cookies";
$PMF_LANG["ad_sess_head"] = "View sessions";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["msgHeaderCategoryOverview"] = "Categories";
$PMF_LANG["ad_menu_stat"] = "Rating Statistics";
$PMF_LANG["msgAddCategory"] = "add main Entity";
$PMF_LANG["ad_kateg_rename"] = "Rename";
$PMF_LANG["ad_adminlog_date"] = "Date";
$PMF_LANG["ad_adminlog_user"] = "User";
$PMF_LANG["ad_adminlog_ip"] = "IP-Adress";

$PMF_LANG["ad_stat_sess"] = "Sessions";
$PMF_LANG["ad_stat_days"] = "Days";
$PMF_LANG["ad_stat_vis"] = "Sessions (Visits)";
$PMF_LANG["ad_stat_vpd"] = "Visits per Day";
$PMF_LANG["ad_stat_fien"] = "First Log";
$PMF_LANG["ad_stat_laen"] = "Last Log";
$PMF_LANG["ad_stat_browse"] = "browse Sessions";
$PMF_LANG["ad_stat_ok"] = "OK";

$PMF_LANG["ad_sess_time"] = "Time";
$PMF_LANG["ad_sess_sid"] = "Session-ID";
$PMF_LANG["ad_sess_ip"] = "IP-Address";

$PMF_LANG["ad_ques_take"] = "Take question and edit";
$PMF_LANG["no_cats"] = "কোনো বিভাগ পাওয়া যায়নি।";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Invalid user or password.";
$PMF_LANG["ad_log_sess"] = "Session expired.";
$PMF_LANG["ad_log_edit"] = "\"Edit User\"-Form for the following user: ";
$PMF_LANG["ad_log_crea"] = "\"New article\" form.";
$PMF_LANG["ad_log_crsa"] = "New entry created.";
$PMF_LANG["ad_log_ussa"] = "Update data for the following user: ";
$PMF_LANG["ad_log_usde"] = "Deleted the following user: ";
$PMF_LANG["ad_log_beed"] = "Edit form for the following user: ";
$PMF_LANG["ad_log_bede"] = "Deleted the following entry: ";

$PMF_LANG["msgVisits"] = "Visits";
$PMF_LANG["ad_start_articles"] = "Articles";
$PMF_LANG["ad_start_comments"] = "Comments";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "paste";
$PMF_LANG["ad_categ_cut"] = "cut";
$PMF_LANG["msgCopy"] = "copy";
$PMF_LANG["ad_categ_process"] = "Processing categories...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>আপনার অনুমতি নেই।</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "আগের পাতা";
$PMF_LANG["msgNextPage"] = "পরের পাতা";
$PMF_LANG["msgPageDoublePoint"] = "পাতা: ";
$PMF_LANG["msgMainCategory"] = "প্রধান বিভাগ";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Your password have changed.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "পিডিএফ হিসাবে দেখুন";
$PMF_LANG["ad_xml_head"] = "XML-Backup";
$PMF_LANG["ad_xml_hint"] = "Save all records of your FAQ in one XML file.";
$PMF_LANG["ad_xml_gen"] = "make XML file";
$PMF_LANG["ad_entry_locale"] = "Language";
$PMF_LANG["msgLanguageSubmit"] = "ভাষা পরির্বতন";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Preview";
$PMF_LANG["ad_attach_1"] = "Please choose a directory for attachments first in configuration.";
$PMF_LANG["ad_attach_2"] = "Please choose a link for attachments first in configuration.";
$PMF_LANG["ad_attach_3"] = "The file attachment.php cannot be opened without proper authentification.";
$PMF_LANG["ad_attach_4"] = "The attached file must be smaller than %s Bytes.";
$PMF_LANG["ad_menu_export"] = "Export";
$PMF_LANG["ad_export_file"] = "Error: Cannot write file.";
$PMF_LANG["ad_export_pdf"] = "PDF-Export of all records";

$PMF_LANG['permission::add_user'] = "ব্যবহারকারী যোগ";
$PMF_LANG['permission::edit_user'] = "ব্যবহারকারী সম্পাদনা";
$PMF_LANG['permission::delete_user'] = "ব্যবহারকারী মোছা";
$PMF_LANG['permission::add_faq'] = "add record";
$PMF_LANG['permission::edit_faq'] = "edit record";
$PMF_LANG['permission::delete_faq'] = "delete record";
$PMF_LANG['permission::viewlog'] = "view log";
$PMF_LANG['permission::adminlog'] = "view admin log";
$PMF_LANG['permission::delcomment'] = "delete comment";
$PMF_LANG['permission::addnews'] = "add news";
$PMF_LANG['permission::editnews'] = "edit news";
$PMF_LANG['permission::delnews'] = "delete news";
$PMF_LANG['permission::addcateg'] = "add category";
$PMF_LANG['permission::editcateg'] = "edit category";
$PMF_LANG['permission::delcateg'] = "delete category";
$PMF_LANG['permission::passwd'] = "change password";
$PMF_LANG['permission::editconfig'] = "edit configuration";
$PMF_LANG['permission::addatt'] = "add attachments";
$PMF_LANG['permission::delatt'] = "delete attachments";
$PMF_LANG['permission::backup'] = "create backup";
$PMF_LANG['permission::restore'] = "restore backup";
$PMF_LANG['permission::delquestion'] = "delete open questions";
$PMF_LANG['permission::changebtrevs'] = "edit revisions";

$PMF_LANG["msgAttachedFiles"] = "ফাইল যোগ করুন";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "action";
$PMF_LANG["msgEmail"] = "Email address";
$PMF_LANG["ad_entry_allowComments"] = "Allow comments";
$PMF_LANG["msgWriteNoComment"] = "আপনি এখানে মতামত দিতে পারবেন না";
$PMF_LANG["msgRealname"] = "real name";
$PMF_LANG["ad_export_generate_pdf"] = "generate PDF file";
$PMF_LANG["ad_export_full_faq"] = "Your FAQ as a PDF file: ";
$PMF_LANG["err_bannedIP"] = "আপনার IP নিষিদ্ধ করা হয়েছে।";
$PMF_LANG["err_SaveQuestion"] = "প্রয়োজনীয় ফিল্ড হল <strong>আপনার নাম</strong>, <strong>আপনার ই-মেইল ঠিকানা</strong>, <strong>আপনার লেখা</strong><strong>আপনার প্রশ্ন</strong><a href=\"javascript:history.back();\">আগের পাতায় ফেরত যান</a><br><br>";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Font color: ";
$PMF_LANG["ad_entry_fontsize"] = "Font size: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array("select", "Language-File");
$LANG_CONF["main.languageDetection"] = array("checkbox", "Enable automatic content negotiation");
$LANG_CONF['main.titleFAQ'] = array("input", "Title of the FAQ");
$LANG_CONF['main.currentVersion'] = array("print", "FAQ Version");
$LANG_CONF["main.metaDescription"] = array("input", "Describtion of the Page");
$LANG_CONF["main.metaPublisher"] = array("input", "Name of the Publisher");
$LANG_CONF['main.administrationMail'] = array("input", "Email address of the Admin");
$LANG_CONF["main.contactInformation"] = array("area", "Contact information");
$LANG_CONF["main.send2friendText"] = array("area", "Text for the send2friend page");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "maximum Size for attachments in Bytes (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", "Link the attachments below the entries?");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", "use Tracking?");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", "use Adminlog?");
$LANG_CONF["security.ipCheck"] = array("checkbox", "Do you want the IP to be checked when checking the UINs in admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", "Number of displayed topics per page");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", "Number of news articles");
$LANG_CONF['security.bannedIPs'] = array("area", "Ban these IPs");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", "Do you want to enable LDAP support? (default: disabled)");
$LANG_CONF["main.referenceURL"] = array("input", "Base URL for link verification (e.g.: https://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array("input", "Interval between AJAX link verification (in seconds)");
$LANG_CONF["records.enableVisibilityQuestions"] = array("checkbox", "Disable visibility of new questions?");
$LANG_CONF['security.permLevel'] = array("select", "Permission level");

$PMF_LANG["ad_categ_new_main_cat"] = "as new main category";
$PMF_LANG["ad_categ_paste_error"] = "Moving this category isn't possible.";
$PMF_LANG["ad_categ_move"] = "move category";
$PMF_LANG["ad_categ_lang"] = "Language";
$PMF_LANG["ad_categ_desc"] = "Description";
$PMF_LANG["ad_categ_change"] = "Change with";

$PMF_LANG["lostPassword"] = "গোপন সংকেত ভুলে গেছেন?";
$PMF_LANG["lostpwd_err_1"] = "পরিচয় এবং এ-মেইল ঠিকানা পাওয়া যায়নি।";
$PMF_LANG["lostpwd_err_2"] = "ভুল তথ্য!";
$PMF_LANG["lostpwd_text_1"] = "তথ্য জানতে চাওয়ার জন্য ধন্যবাদ।";
$PMF_LANG["lostpwd_text_2"] = "অনুগ্রহ করে প্রশাসকের বিভাগে একটি নতুন গোপন সংকেত প্রদান করুন।";
$PMF_LANG["lostpwd_mail_okay"] = "ই-মেইল পাঠানো হয়েছে";

$PMF_LANG["msgButtonFetchLatestVersion"] = "Get latest phpMyFAQ version number by web service";
$PMF_LANG["ad_xmlrpc_latest"] = "Latest version available on";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'বিভাগের ভাষা নির্বাচন';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'সাইট ম্যাপ';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'এই লেখাটি সম্পাদনা করা হচ্ছে তাই দেখানো সম্ভব না।';
$PMF_LANG['msgArticleCategories'] = 'প্রশ্নটির বিভাগ';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'Unique solution ID';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ record';
$PMF_LANG['ad_entry_new_revision'] = 'Create new revision?';
$PMF_LANG['ad_entry_record_administration'] = 'Record administration';
$PMF_LANG['ad_entry_changelog'] = 'Changelog';
$PMF_LANG['ad_entry_revision'] = 'Revision';
$PMF_LANG['ad_changerev'] = 'Select Revision';
$PMF_LANG['msgCaptcha'] = "ছবিতে দেখা অক্ষরগুলো লিখুন";
$PMF_LANG['msgSelectCategories'] = 'খুঁজুন ...';
$PMF_LANG['msgAllCategories'] = '... সকল বিভাগ';
$PMF_LANG['ad_you_should_update'] = 'Your phpMyFAQ installation is outdated. You should update to the latest available version.';
$PMF_LANG['msgAdvancedSearch'] = 'খোঁজার উন্নত ব্যবস্থা';

// added v1.6.1 - 2006-04-25 by Matteo and Thorsten
$PMF_LANG['spamControlCenter'] = 'Spam control center';
$LANG_CONF["spam.enableSafeEmail"] = array("checkbox", "Print user email in a safe way (default: enabled).");
$LANG_CONF["spam.checkBannedWords"] = array("checkbox", "Check public form content against banned words (default: enabled).");
$LANG_CONF["spam.enableCaptchaCode"] = array("checkbox", "Use a catpcha code to allow public form submission (default: enabled).");
$PMF_LANG['ad_session_expiring'] = 'Your session will expire in %d minutes: would you like to go on working?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Sessions management';
$PMF_LANG['ad_stat_choose'] = 'Choose the month';
$PMF_LANG['ad_stat_delete'] = 'Delete immediately the selected sessions';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Glossary';
$PMF_LANG['ad_glossary_add'] = 'Add glossary entry';
$PMF_LANG['ad_glossary_edit'] = 'Edit glossary entry';
$PMF_LANG['ad_glossary_item'] = 'Item';
$PMF_LANG['ad_glossary_definition'] = 'Definition';
$PMF_LANG['ad_glossary_save'] = 'Save entry';
$PMF_LANG['ad_glossary_save_success'] = 'Glossary entry successfully saved!';
$PMF_LANG['ad_glossary_save_error'] = 'The glossary entry could not saved because an error occurred.';
$PMF_LANG['ad_glossary_update_success'] = 'Glossary entry successfully updated!';
$PMF_LANG['ad_glossary_update_error'] = 'The glossary entry could not updated because an error occurred.';
$PMF_LANG['ad_glossary_delete'] = 'Delete entry';
$PMF_LANG['ad_glossary_delete_success'] = 'Glossary entry successfully deleted!';
$PMF_LANG['ad_glossary_delete_error'] = 'The glossary entry could not deleted because an error occurred.';
$PMF_LANG['msgNewQuestionVisible'] = 'প্রশ্নটি রিভিউ করার পর প্রকাশিত হবে।';
$PMF_LANG['msgQuestionsWaiting'] = 'প্রকাশিত হওয়ার অপেক্ষায়: ';
$PMF_LANG['ad_entry_visibility'] = 'Publish?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] = "Please enter a password. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "Passwords do not match. ";
$PMF_LANG['ad_user_error_loginInvalid'] = "The specified user name is invalid.";
$PMF_LANG['ad_user_error_noEmail'] = "Please enter a valid mail adress. ";
$PMF_LANG['ad_user_error_noRealName'] = "Please enter your real name. ";
$PMF_LANG['ad_user_error_delete'] = "User account could not be deleted. ";
$PMF_LANG['ad_user_error_noId'] = "No ID specified. ";
$PMF_LANG['ad_user_error_protectedAccount'] = "User account is protected. ";
$PMF_LANG['ad_user_deleteUser'] = "Delete User";
$PMF_LANG['ad_user_status'] = "Status";
$PMF_LANG['ad_user_lastModified'] = "last modified";
$PMF_LANG['ad_gen_cancel'] = "Cancel";
$PMF_LANG['permission::addglossary'] = "add glossary item";
$PMF_LANG['permission::editglossary'] = "edit glossary item";
$PMF_LANG['permission::delglossary'] = "delete glossary item";
$PMF_LANG["ad_menu_group_administration"] = "Groups";
$PMF_LANG['ad_user_loggedin'] = 'লগইন করেছেন ';

$PMF_LANG['ad_group_details'] = "Group Details";
$PMF_LANG['ad_group_add'] = "Add Group";
$PMF_LANG['ad_group_add_link'] = "Add Group";
$PMF_LANG['ad_group_name'] = "Name";
$PMF_LANG['ad_group_description'] = "Description";
$PMF_LANG['ad_group_autoJoin'] = "Auto-join";
$PMF_LANG['ad_group_suc'] = "Group <strong>successfully</strong> added.";
$PMF_LANG['ad_group_error_noName'] = "Please enter a group name. ";
$PMF_LANG['ad_group_error_delete'] = "Group could not be deleted. ";
$PMF_LANG['ad_group_deleted'] = "The group was successfully deleted.";
$PMF_LANG['ad_group_deleteGroup'] = "Delete Group";
$PMF_LANG['ad_group_deleteQuestion'] = "Are you sure that this group shall be deleted?";
$PMF_LANG['ad_user_uncheckall'] = "Unselect All";
$PMF_LANG['ad_group_membership'] = "Group Membership";
$PMF_LANG['ad_group_members'] = "Members";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Limit the FAQ data to be exported (optional)';
$PMF_LANG['ad_export_cat_downwards'] = 'Downwards?';
$PMF_LANG['ad_export_type'] = 'Format of the export';
$PMF_LANG['ad_export_type_choose'] = 'Choose one of the supported formats:';
$PMF_LANG['ad_export_download_view'] = 'Download or view in-line?';
$PMF_LANG['ad_export_download'] = 'download';
$PMF_LANG['ad_export_view'] = 'view in-line';
$PMF_LANG['ad_export_gen_xhtml'] = 'Make XHTML file';
$PMF_LANG['ad_export_gen_docbook'] = 'Make Docbook file';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'News data';
$PMF_LANG['ad_news_author_name'] = 'Author name:';
$PMF_LANG['ad_news_author_email'] = 'Author email:';
$PMF_LANG['ad_news_set_active'] = 'Activate';
$PMF_LANG['ad_news_allowComments'] = 'Allow comments:';
$PMF_LANG['ad_news_expiration_window'] = 'News expiration time window (optional)';
$PMF_LANG['ad_news_from'] = 'From:';
$PMF_LANG['ad_news_to'] = 'To:';
$PMF_LANG['ad_news_insertfail'] = 'An error occurred inserting the news item into the database.';
$PMF_LANG['ad_news_updatefail'] = 'An error occurred updating the news item into the database.';
$PMF_LANG['newsShowCurrent'] = 'র্বতমান খবর দেখুন।';
$PMF_LANG['newsShowArchive'] = 'খবরের আর্কাইভ দেখুন।';
$PMF_LANG['newsArchive'] = ' খবরের আর্কাইভ';
$PMF_LANG['newsWriteComment'] = 'মতামত';
$PMF_LANG['newsCommentDate'] = 'যোগ হয়েছে -> ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Record expiration time window (optional)';
$PMF_LANG['adminHeaderDashboard'] = 'Home';
$PMF_LANG['admin_mainmenu_users'] = 'Users';
$PMF_LANG['admin_mainmenu_content'] = 'Content';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistics';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup';
$PMF_LANG['admin_mainmenu_configuration'] = 'Configuration';
$PMF_LANG['admin_mainmenu_logout'] = 'Logout';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Entity owner';
$PMF_LANG['adminSection'] = 'প্রশাসক';
$PMF_LANG['err_expiredArticle'] = 'প্রশ্নটির মেয়াদ উত্তীর্ণ হয়েছে তাই দেখানো সম্ভব না।';
$PMF_LANG['err_expiredNews'] = 'খবরটির মেয়াদ উত্তীর্ণ হয়েছে তাই দেখানো সম্ভব না।';
$PMF_LANG['err_inactiveNews'] = 'এই লেখাটি সম্পাদনা করা হচ্ছে তাই দেখানো সম্ভব না।';
$PMF_LANG['msgSearchOnAllLanguages'] = 'সব ভাষায় খুঁজুন:';
$PMF_LANG['ad_entry_tags'] = 'Tags';
$PMF_LANG['msg_tags'] = 'ট্যাগ সমূহ';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'সম্পর্কিত লেখা';
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "Number of related entries");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Translate';
$PMF_LANG['ad_categ_trans_2'] = 'Entity';
$PMF_LANG['ad_categ_translatecateg'] = 'Translate Entity';
$PMF_LANG['ad_categ_translate'] = 'Translate';
$PMF_LANG['ad_categ_transalready'] = 'Already translated in: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Delete in all languages?';
$PMF_LANG["ad_categ_deletethislang"] = 'Delete in this language only?';
$PMF_LANG["ad_categ_translated"] = "The category has been translated.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["msgCategoryMatrix"] = "Overview";
$PMF_LANG['ad_menu_categ_structure'] = "Entity Overview including its languages";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'User permissions';
$PMF_LANG['ad_entry_grouppermission'] = 'Group permissions';
$PMF_LANG['ad_entry_all_users'] = 'Access for all users';
$PMF_LANG['ad_entry_restricted_users'] = 'Restricted access to';
$PMF_LANG['ad_entry_all_groups'] = 'Access for all groups';
$PMF_LANG['ad_entry_restricted_groups'] = 'Restricted access to';
$PMF_LANG['ad_session_expiration'] = 'Time to your session expiration';
$PMF_LANG['ad_user_active'] = 'active';
$PMF_LANG['ad_user_blocked'] = 'blocked';
$PMF_LANG['ad_user_protected'] = 'protected';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Select a FAQ record to insert it as a link...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Paste after";
$PMF_LANG["msgCategoryRemark_overview"] = "The correct order of categories will be shown, if all categories are defined for the actual language (first column).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = ' ও %d জন অতিথি অনলাইনে';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Delete immediately logs older than 30 days';
$PMF_LANG['ad_adminlog_delete_success'] = 'Older logs successfully deleted.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'No logs deleted: an error occurred performing the request.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['ad_quicklinks'] = 'Links';
$PMF_LANG['ad_quick_category'] = 'নতুন বিভাগ যোগ';
$PMF_LANG['ad_quick_record'] = 'নতুন প্রশ্ন-উত্তর যোগ';
$PMF_LANG['ad_quick_user'] = 'নতুন ব্যবহারকারী যোগ';
$PMF_LANG['ad_quick_group'] = 'নতুন দল যোগ';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'অনুবাদ প্রস্তাবনা';
$PMF_LANG['msgNewTranslationAddon'] = 'আপনার মতামত প্রশাসকের অনুমোদনের পর প্রকাশিত হবে। বাধ্যতামূলকঃ <strong>আপনার নাম</strong>, <strong>আপনার ই-মেইল ঠিকানা</strong>, <strong>শিরোনাম অনুবাদ</strong> এবং<strong>আপনার প্রশ্ন-উত্তর অনুবাদ</strong>। চাবি-শব্দগুলো space দিয়ে আলাদা করুন।';
$PMF_LANG['msgNewTransSourcePane'] = 'মূল লেখা';
$PMF_LANG['msgNewTranslationPane'] = 'অনুবাদ';
$PMF_LANG['msgNewTranslationName'] = "Your Name";
$PMF_LANG['msgNewTranslationMail'] = "Your email address";
$PMF_LANG['msgNewTranslationKeywords'] = "Keywords";
$PMF_LANG['msgNewTranslationSubmit'] = 'আপনার প্রস্তাবনা জমা দিন';
$PMF_LANG['msgTranslate'] = 'অনুবাদের প্রস্তাব';
$PMF_LANG['msgTranslateSubmit'] = 'অনুবাদ শুরু...';
$PMF_LANG['msgNewTranslationThanks'] = "আপনার অনুবাদ প্রস্তাবের জন্য ধন্যবাদ!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG['permission::addgroup'] = "add group accounts";
$PMF_LANG['permission::editgroup'] = "edit group accounts";
$PMF_LANG['permission::delgroup'] = "delete group accounts";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Link opens in parent window';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Comments';
$PMF_LANG['adminHeaderComments'] = 'Comments administration';
$PMF_LANG['msgAdminCommentFaqs'] = 'Comments in FAQ records:';
$PMF_LANG['msgAdminCommentNews'] = 'Comments in News records:';
$PMF_LANG['ad_groups'] = 'Groups';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array('select', 'Record sorting (according to property)');
$LANG_CONF['records.sortby'] = array('select', 'Record sorting (descending or ascending)');
$PMF_LANG['ad_conf_order_id'] = 'ID (default)';
$PMF_LANG['ad_conf_order_thema'] = 'Title';
$PMF_LANG['ad_conf_order_visits'] = 'Number of visitors';
$PMF_LANG['ad_conf_order_updated'] = 'Date';
$PMF_LANG['ad_conf_order_author'] = 'Author';
$PMF_LANG['ad_conf_desc'] = 'descending';
$PMF_LANG['ad_conf_asc'] = 'ascending';
$PMF_LANG['mainControlCenter'] = 'Main Control Center';
$PMF_LANG['recordsControlCenter'] = 'FAQ records configuration';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array("checkbox", 'Activate a new records', 'Default: disallowed');
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", 'Allow comments for new records', 'Default: disallowed');

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'এই বিভাগের প্রশ্ন';
$PMF_LANG['msgTagSearch'] = 'ট্যাগ';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Information';
$PMF_LANG['msgOnlineVersionCheck'] = 'Online version check';
$PMF_LANG['ad_system_info'] = 'System Information';

return $PMF_LANG;
